set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6002143';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '1',
      NULL,
      NULL,
      '1',
      '3',
      '1',
      '1',
      '4',
      '0',
      NULL,
      '3',
      NULL,
      '0',
      NULL,
      '0',
      '2',
      NULL,
      '3',
      '4',
      NULL,
      '1',
      '1',
      '4',
      '',
      '4',
      '',
      '3',
      '4',
      '0',
      '2',
      '3',
      '',
      '',
      '0',
      '3',
      NULL,
      '4',
      '3',
      '4',
      '1',
      '4',
      '2',
      NULL,
      '2',
      '102',
      '41022210',
      NULL,
      NULL,
      '4414144',
      3.310653,
      NULL,
      1,
      1,
      '024402',
      6.017142,
      ' 1-11-1999',
      '10- 7-2003',
      NULL,
      105,
      5,
      9.301819,
      4.982050,
      5,
      7.127822,
      NULL,
      7.304791,
      7.837163,
      NULL,
      NULL,
      NULL,
      8.260384,
      22.749792,
      3,
      14.289781,
      5,
      5.305671,
      4.545555,
      25,
      15,
      18,
      0,
      0.719678,
      6,
      138.377269,
      39.725069,
      115,
      15,
      145.787201,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      31,
      40.435866,
      NULL,
      20.246135,
      3,
      ' 3-17-1999',
      1.120444,
      0.715305,
      85,
      1.417374,
      1,
      17,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 2-1975',
      19.729178,
      NULL,
      72,
      33,
      12.765480,
      39,
      108.474138,
      109.807196,
      52.680582,
      67,
      47,
      56.876410,
      ' 9- 0-1990',
      NULL,
      6.862646,
      NULL,
      15,
      33.660937,
      7,
      0.990182,
      ' 2- 7-1993',
      3,
      4.249738,
      ' 0-25-1976',
      NULL,
      7.324870,
      11,
      11.439573,
      9.904365,
      NULL,
      1,
      NULL,
      1.703140,
      NULL,
      2,
      NULL,
      9,
      16,
      0,
      15.969729,
      0.786560,
      NULL,
      ' 0- 7-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      41,
      4.165123,
      ' 3- 2-1981',
      NULL,
      NULL,
      NULL,
      12,
      NULL,
      5,
      ' 5-13-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      ' 0-10-1996',
      4.685869,
      17.986817,
      3,
      ' 4-14-2002',
      3,
      334,
      '10- 3-1986',
      5.359985,
      NULL,
      3.788856,
      29,
      ' 8-11-1986',
      41,
      NULL,
      60.128746,
      ' 5-14-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


