set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9718351';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '2',
      NULL,
      '4',
      NULL,
      '1',
      NULL,
      '0',
      '3',
      '2',
      '2',
      '4',
      '3',
      '4',
      '3',
      '1',
      '3',
      '0',
      '0',
      '0',
      '3',
      '0',
      '2',
      NULL,
      '',
      '3',
      '',
      NULL,
      '2',
      NULL,
      NULL,
      '2',
      '',
      '',
      '0',
      '1',
      '3',
      '3',
      NULL,
      '4',
      '3',
      '0',
      '1',
      '1',
      '4',
      '233',
      '40323213',
      59.599153,
      54.920263,
      '4333123',
      0.724836,
      0.898896,
      2,
      0,
      NULL,
      5,
      ' 1- 0-1979',
      ' 3- 0-1999',
      11,
      NULL,
      17,
      9,
      2.576121,
      7.737401,
      NULL,
      17,
      7,
      19.079552,
      NULL,
      NULL,
      8.256417,
      NULL,
      5,
      9,
      33.876295,
      3,
      NULL,
      NULL,
      38,
      8.323195,
      95.953181,
      17.828014,
      0,
      149.888388,
      43,
      30.424312,
      NULL,
      44,
      138,
      ' 2-29-1981',
      60.848984,
      58,
      11,
      35,
      NULL,
      83,
      ' 9- 4-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      94.643697,
      12,
      4,
      9,
      9,
      NULL,
      ' 0- 9-2001',
      1,
      1,
      212.197949,
      NULL,
      NULL,
      60.134901,
      1.204696,
      3.706333,
      32.892494,
      NULL,
      NULL,
      NULL,
      ' 2- 9-1974',
      23,
      40.357398,
      91.030387,
      71.876298,
      94.619916,
      NULL,
      NULL,
      54,
      70.652471,
      86.706061,
      NULL,
      95.027289,
      ' 1-25-1992',
      NULL,
      32.824066,
      41.398691,
      34.304395,
      68,
      NULL,
      3,
      '11-16-1992',
      6,
      0.632974,
      ' 2-13-1981',
      6.768857,
      10.009164,
      NULL,
      21,
      NULL,
      NULL,
      NULL,
      15.042428,
      0,
      40,
      NULL,
      NULL,
      NULL,
      26,
      1.152273,
      1,
      3,
      1,
      ' 4-23-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      180,
      1,
      ' 4-21-1989',
      NULL,
      NULL,
      NULL,
      17,
      ' 1-20-1995',
      47,
      ' 0-21-1978',
      15.054745,
      15.551498,
      ' 5-24-1996',
      NULL,
      NULL,
      ' 6-17-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      19,
      NULL,
      NULL,
      NULL,
      7,
      ' 1-17-1989',
      1.763865,
      NULL,
      '10-21-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


