set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6220693';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2334',
      '41113142',
      NULL,
      '43334413',
      '23413022',
      NULL,
      '13440341',
      '41344334',
      '40313040',
      '30200044',
      '12210443',
      '01420103',
      '33221323',
      '10130142',
      '33243322',
      '32011140',
      '34243121',
      '14303421',
      '21333331',
      '21233321',
      '24201241',
      '02311114',
      '41141304',
      NULL,
      NULL,
      '13414242',
      '11031211',
      '00001042',
      NULL,
      '31231313',
      NULL,
      NULL,
      '10040413',
      '03302003',
      '04042144',
      '43434132',
      '11130030',
      '44004043',
      '11011403',
      '13230111',
      '40001400',
      '01434101',
      NULL,
      '21333044',
      '13430002',
      '443',
      NULL,
      NULL,
      7.448712,
      '1033322',
      NULL,
      1.334713,
      2,
      NULL,
      '234121',
      NULL,
      ' 0- 0-1988',
      ' 4-27-2000',
      NULL,
      5.110071,
      15.859169,
      14.249649,
      4.406200,
      15.087908,
      78.032317,
      12.562584,
      NULL,
      8,
      40,
      10.832608,
      NULL,
      13,
      NULL,
      0.789328,
      1.293683,
      6,
      15,
      3.133343,
      3.604129,
      11.832828,
      40.813674,
      2.799854,
      0,
      76,
      92,
      40,
      103.228682,
      22,
      NULL,
      '11-17-1987',
      4,
      NULL,
      9.185132,
      6.297734,
      14.999959,
      11.114315,
      ' 3-10-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      25,
      NULL,
      8.059619,
      17,
      27.257826,
      1.154152,
      '10-19-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      31,
      NULL,
      110,
      99.675509,
      49.605366,
      80.728323,
      30,
      45,
      22.611231,
      23.870074,
      5.721215,
      23.167867,
      '10-24-1995',
      NULL,
      15,
      NULL,
      31,
      NULL,
      17,
      5,
      ' 3-23-1985',
      1.954589,
      16,
      '10-18-1983',
      4.266265,
      NULL,
      2,
      NULL,
      1.512942,
      0.650336,
      2.750111,
      2.801304,
      1.605986,
      3.732164,
      1.411738,
      4,
      0.259935,
      13.158354,
      10,
      NULL,
      0,
      NULL,
      '10-10-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      98.377917,
      NULL,
      ' 5-19-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-25-1982',
      1.124514,
      ' 1-23-2000',
      1.248564,
      NULL,
      ' 8-13-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      3,
      '10-11-1987',
      13.979136,
      13,
      0,
      ' 6-14-1974',
      0,
      NULL,
      ' 3- 9-1981',
      1.298241,
      154,
      9.963573,
      NULL,
      ' 8-13-1977',
      6.000226,
      1.163797,
      20.216183,
      ' 7- 2-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


