set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6220693';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '1',
      '1',
      '2',
      '3',
      '0',
      '1',
      '3',
      '0',
      '3',
      NULL,
      '3',
      NULL,
      '1',
      '0',
      '0',
      '0',
      NULL,
      '4',
      '0',
      '0',
      '0',
      '2',
      '4',
      '',
      '1',
      '',
      '3',
      NULL,
      '4',
      '0',
      '1',
      '',
      '',
      '2',
      '1',
      '4',
      '0',
      '2',
      '2',
      NULL,
      '3',
      '4',
      '4',
      '4',
      '011',
      NULL,
      NULL,
      65,
      '0111342',
      2,
      33.108997,
      NULL,
      NULL,
      '242332',
      4,
      ' 7-20-1993',
      NULL,
      NULL,
      200,
      32,
      10,
      22,
      3.601175,
      NULL,
      9,
      7,
      12,
      NULL,
      14.765238,
      26,
      16.866097,
      16.760789,
      5,
      9.267756,
      12,
      8.498970,
      0.561901,
      11.342875,
      1.878557,
      45,
      NULL,
      0,
      93,
      NULL,
      18.446184,
      29.508716,
      NULL,
      3,
      ' 5-12-2000',
      9.940501,
      8.743526,
      16,
      12,
      NULL,
      68,
      ' 4- 6-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      77,
      13.429493,
      31,
      1.492211,
      NULL,
      5.595814,
      ' 3-11-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      47,
      4.789957,
      NULL,
      56.977360,
      72,
      99,
      NULL,
      34.589621,
      66.361960,
      50.263387,
      6,
      80.028387,
      ' 8-18-1975',
      1,
      1,
      6,
      13.118575,
      15,
      0.925056,
      1.048978,
      NULL,
      4.260330,
      11.143855,
      ' 8-20-1976',
      5.426556,
      NULL,
      4.651942,
      1.660510,
      NULL,
      NULL,
      4.294737,
      1.383105,
      NULL,
      NULL,
      0.999418,
      1,
      0,
      NULL,
      3,
      NULL,
      NULL,
      0.125557,
      ' 2-16-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      40.606938,
      17.242404,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      2.375675,
      ' 4-25-1976',
      5,
      3.023039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      2,
      ' 0-29-1986',
      1,
      1,
      0,
      NULL,
      0.735389,
      265,
      ' 9-15-1987',
      2.124056,
      4,
      12.226382,
      85,
      ' 9- 0-1979',
      22,
      1,
      125.287718,
      ' 9-16-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


