set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9888127';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '1',
      '4',
      NULL,
      '4',
      '2',
      '1',
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      '3',
      '0',
      '1',
      '1',
      '1',
      '0',
      '0',
      '1',
      NULL,
      '4',
      '0',
      NULL,
      NULL,
      '2',
      '',
      NULL,
      '2',
      '1',
      '1',
      '1',
      '',
      '',
      '2',
      '4',
      '0',
      '0',
      '2',
      '2',
      '2',
      '0',
      NULL,
      '0',
      NULL,
      '400',
      '40132221',
      NULL,
      NULL,
      '3433214',
      1.959771,
      0,
      1,
      0,
      '133301',
      1.627390,
      '10- 4-1981',
      ' 0-10-1984',
      NULL,
      81.643732,
      3.543965,
      NULL,
      14.453283,
      7,
      52,
      NULL,
      4,
      13,
      3,
      3.161610,
      9.368445,
      NULL,
      7.583102,
      6,
      0,
      3.446697,
      7.530226,
      2.661112,
      19,
      2,
      18,
      0,
      1.683734,
      1,
      111.447313,
      27,
      NULL,
      46,
      96.008229,
      ' 2-18-1988',
      35,
      NULL,
      12.786182,
      15,
      105,
      NULL,
      '10-21-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19.569615,
      40,
      NULL,
      5.864442,
      NULL,
      0.685434,
      NULL,
      1.556758,
      0,
      NULL,
      0.747863,
      7.121815,
      46,
      NULL,
      0,
      6,
      NULL,
      NULL,
      NULL,
      ' 9-11-1997',
      2.396530,
      NULL,
      65,
      42,
      46.754971,
      17,
      NULL,
      46.943579,
      32.839705,
      59,
      81.719613,
      78,
      ' 4-28-1990',
      1,
      4.700396,
      13.164642,
      19.259626,
      55.400175,
      3.674300,
      1.435198,
      NULL,
      14,
      0,
      ' 9- 1-1987',
      NULL,
      10.955044,
      0,
      10.956083,
      2,
      0.221382,
      2.345434,
      9,
      1,
      64.435076,
      5,
      1.284505,
      3,
      19,
      2.732227,
      0.073661,
      3,
      0,
      ' 3- 3-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      76,
      49,
      ' 4- 8-1985',
      NULL,
      NULL,
      NULL,
      12.741929,
      ' 1-10-1985',
      14.667421,
      ' 9-23-1979',
      11,
      7.280226,
      '10-15-2003',
      NULL,
      34,
      ' 1- 9-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2,
      NULL,
      4.014481,
      11.027460,
      12,
      ' 2-28-1995',
      1,
      325.660169,
      ' 2-12-1989',
      6.611512,
      31,
      17.655064,
      13.064876,
      ' 5-23-1984',
      17.861590,
      NULL,
      19,
      ' 3-28-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


