set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8602759';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4044',
      '04143302',
      '22003343',
      '24402104',
      '42310231',
      '11330022',
      '24221102',
      '11443333',
      '02032300',
      '43302422',
      '21423243',
      '43311042',
      NULL,
      '44130224',
      '10034211',
      '43333102',
      NULL,
      '20240343',
      '40443403',
      '03200321',
      '10440444',
      '34432021',
      '33414413',
      '04401013',
      '23000411',
      NULL,
      '40434130',
      NULL,
      '24132300',
      '21320114',
      '40130433',
      '32124310',
      '30034301',
      NULL,
      '21140212',
      '00434033',
      '12004140',
      NULL,
      '03240312',
      '22034120',
      '41112201',
      '13024034',
      NULL,
      '02430401',
      NULL,
      '223',
      '10',
      NULL,
      NULL,
      '3221112',
      3.254116,
      0,
      1,
      NULL,
      '424024',
      5.910194,
      ' 6-18-1993',
      ' 0-16-1989',
      38.841791,
      NULL,
      18.500577,
      14,
      18.244650,
      17,
      81.813503,
      2,
      4.760650,
      3,
      NULL,
      0.857006,
      28,
      NULL,
      10.432361,
      3.686454,
      6,
      12,
      NULL,
      9,
      47.594256,
      6.434400,
      30.653145,
      31.385048,
      0,
      78,
      1.259912,
      NULL,
      50.907698,
      NULL,
      8,
      ' 6- 1-1991',
      9,
      49,
      NULL,
      14.983284,
      NULL,
      189.259072,
      ' 3- 6-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      60,
      24,
      4,
      5,
      1.888909,
      7,
      ' 7-22-1978',
      1,
      1.804943,
      1,
      1,
      1,
      8,
      1,
      0.714610,
      78.773373,
      NULL,
      NULL,
      NULL,
      ' 8- 8-1975',
      54.189602,
      8.884701,
      22,
      96.595235,
      NULL,
      47,
      2,
      NULL,
      62.971755,
      NULL,
      NULL,
      59.943815,
      NULL,
      13,
      NULL,
      8,
      23,
      1.536941,
      5.634434,
      7,
      '11- 3-1988',
      31.743499,
      21.912314,
      ' 5-12-1999',
      6.436761,
      NULL,
      5.588843,
      18.284040,
      3.967394,
      11.590559,
      1,
      23.345915,
      NULL,
      47,
      3.351353,
      1,
      19.240353,
      9.749155,
      0.365251,
      0,
      1,
      1.633549,
      '10-21-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      60.818899,
      13.470222,
      ' 9-24-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-16-1980',
      13.029697,
      ' 9-20-1975',
      4,
      15,
      '10- 4-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      19,
      ' 5-14-1983',
      NULL,
      NULL,
      1,
      ' 8-28-1975',
      NULL,
      NULL,
      ' 3-18-2000',
      8.935721,
      5.515803,
      18,
      101,
      NULL,
      46,
      1,
      159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


