set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8602759';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '2',
      '0',
      NULL,
      '0',
      '1',
      '1',
      '1',
      '3',
      NULL,
      '4',
      NULL,
      '4',
      '2',
      '4',
      '1',
      NULL,
      '4',
      '0',
      '3',
      '4',
      '2',
      '1',
      '3',
      '',
      '4',
      '',
      NULL,
      '2',
      '0',
      '0',
      '1',
      '',
      '',
      '3',
      '1',
      NULL,
      '2',
      '4',
      '4',
      '3',
      '4',
      '1',
      '3',
      '3',
      '402',
      '22331320',
      33.098481,
      24,
      '0334431',
      2.993937,
      43,
      NULL,
      NULL,
      '302041',
      NULL,
      ' 3-14-2002',
      ' 9-11-1996',
      61,
      102.843033,
      24.154132,
      2,
      3,
      11.818550,
      NULL,
      1,
      NULL,
      NULL,
      17.216831,
      11,
      20.954059,
      4.751379,
      12.097238,
      NULL,
      11,
      14,
      13,
      6,
      18.819297,
      0,
      5.648328,
      21,
      1.421825,
      NULL,
      78,
      NULL,
      173,
      49,
      NULL,
      '10-15-1976',
      2,
      69,
      NULL,
      NULL,
      196.429319,
      NULL,
      ' 5- 8-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      32.363108,
      32.457767,
      25,
      10.788458,
      1.790811,
      1.742777,
      '10-21-1984',
      0,
      1,
      NULL,
      0.917741,
      0,
      63,
      0.245509,
      0,
      64,
      NULL,
      NULL,
      NULL,
      '11- 0-1981',
      19,
      32.157481,
      NULL,
      NULL,
      53.404677,
      62,
      27,
      NULL,
      NULL,
      NULL,
      17,
      44,
      NULL,
      NULL,
      7,
      NULL,
      18.085396,
      31,
      50,
      11,
      NULL,
      25,
      NULL,
      NULL,
      12,
      NULL,
      NULL,
      10,
      21.197849,
      NULL,
      3.869385,
      6.447422,
      NULL,
      56,
      1,
      1,
      10,
      30,
      1,
      1.941753,
      0.246938,
      0,
      '10- 2-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      111,
      17,
      NULL,
      NULL,
      NULL,
      NULL,
      11.508763,
      ' 5- 1-1993',
      48,
      ' 0- 7-1984',
      5.092794,
      14,
      NULL,
      88.977151,
      55,
      ' 3- 7-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      10.047047,
      ' 8-17-1981',
      NULL,
      NULL,
      20.268477,
      ' 5- 8-1991',
      1,
      1,
      '10-16-1986',
      13.330124,
      45.138219,
      NULL,
      142,
      ' 7- 7-1995',
      61,
      NULL,
      20,
      ' 0-17-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


