set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9107390';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1432',
      '31433223',
      '20232424',
      '30332132',
      '21134212',
      '13023100',
      NULL,
      '12434131',
      '43004340',
      NULL,
      '03400312',
      '31024224',
      '43211233',
      NULL,
      NULL,
      '20233004',
      '34123130',
      NULL,
      '01231123',
      '02322134',
      '20221000',
      '43123343',
      '21332433',
      '23421240',
      '12411112',
      '40104103',
      '21414341',
      '30344222',
      '03022012',
      '24244113',
      '13103134',
      NULL,
      '20032440',
      '31102133',
      '24443300',
      NULL,
      '32301401',
      '41001341',
      '32133034',
      '20143014',
      '33313410',
      '21322311',
      '32210104',
      '32011041',
      '24312431',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      1.969075,
      1,
      NULL,
      '433042',
      2,
      ' 0-12-1988',
      '11- 3-1988',
      46,
      NULL,
      12,
      17.963771,
      39.901807,
      9,
      NULL,
      NULL,
      NULL,
      22,
      NULL,
      13.838919,
      15.138316,
      0,
      NULL,
      4.715184,
      15,
      19.566882,
      46.000365,
      NULL,
      36,
      5.595730,
      70.999249,
      10.707434,
      NULL,
      113,
      NULL,
      24,
      NULL,
      116.009768,
      NULL,
      '11-27-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.967275,
      NULL,
      NULL,
      1.620957,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.300626,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-15-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-17-1997',
      NULL,
      64.841869,
      54,
      NULL,
      96,
      NULL,
      111.929419,
      NULL,
      105.530372,
      4.727183,
      NULL,
      58.006954,
      ' 3- 9-1985',
      17.302619,
      NULL,
      NULL,
      NULL,
      52,
      36.060857,
      8,
      NULL,
      9,
      NULL,
      NULL,
      0.488460,
      3,
      25.306694,
      14.136498,
      12.041438,
      8.728595,
      NULL,
      NULL,
      NULL,
      59.821241,
      1.509793,
      1,
      0.763138,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 7-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      53.314128,
      NULL,
      40.658033,
      ' 2-11-1985',
      0,
      92,
      ' 2-24-1998',
      NULL,
      7.270027,
      19.739180,
      34,
      ' 5-26-1980',
      19,
      1.134785,
      NULL,
      ' 2- 8-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      0.811153,
      0.021288,
      NULL,
      NULL,
      NULL,
      68.246348,
      24.348894,
      92.778955,
      46.371615,
      1,
      62,
      1,
      2.705734,
      93,
      2,
      1.607054,
      22.352713,
      1,
      1.620450,
      128,
      1.561754,
      1.949539,
      25,
      65,
      22,
      NULL,
      1.954259,
      0,
      0,
      0,
      0,
      1.674676,
      1.129268,
      NULL,
      47,
      91.969116,
      29.209616,
      NULL,
      37,
      44,
      0,
      0,
      NULL,
      0,
      1,
      1.880786,
      4,
      0,
      9,
      1,
      NULL,
      1.916949,
      NULL,
      50,
      13,
      0.768716,
      21.466975,
      11,
      65.358110,
      9,
      NULL,
      17,
      2.929367,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.252727,
      89,
      '11-10-1984',
      '10-13-1986',
      ' 5-25-1995',
      NULL,
      ' 2-15-2001',
      NULL,
      ' 3-27-1999',
      NULL);
commit;
end;
/


