set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9773907';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '3',
      '2',
      '3',
      '4',
      '3',
      '4',
      '4',
      '0',
      '2',
      '0',
      '4',
      '2',
      '1',
      NULL,
      '2',
      NULL,
      '0',
      '1',
      '3',
      '2',
      NULL,
      NULL,
      '0',
      '',
      '4',
      '',
      '3',
      NULL,
      '2',
      '0',
      '2',
      '',
      NULL,
      '2',
      '0',
      '3',
      '3',
      '4',
      '2',
      '1',
      '3',
      '0',
      '1',
      '1',
      '010',
      '00230343',
      NULL,
      31.868487,
      '1312030',
      2.197906,
      1.864028,
      3,
      NULL,
      NULL,
      NULL,
      ' 5-21-2002',
      '11- 1-1992',
      104.910428,
      248,
      NULL,
      0.221190,
      31,
      13.279827,
      48,
      12,
      5.650848,
      7.670221,
      NULL,
      NULL,
      38,
      21.159262,
      22.537526,
      17,
      NULL,
      4,
      76,
      1,
      6,
      NULL,
      91.896022,
      1.171459,
      1,
      8.985688,
      112,
      35.445809,
      NULL,
      138.611790,
      168,
      '11-20-1997',
      10.779829,
      NULL,
      NULL,
      19.447734,
      57.808424,
      119,
      ' 6-25-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      25,
      1,
      4,
      NULL,
      9,
      ' 4-11-1976',
      0.598219,
      NULL,
      193.614487,
      1.414617,
      NULL,
      108,
      1,
      0.270451,
      18.552791,
      NULL,
      NULL,
      NULL,
      ' 4-23-1981',
      1.983784,
      21,
      NULL,
      30,
      27,
      49.225409,
      NULL,
      46.379375,
      5,
      48.346505,
      73,
      66.840379,
      NULL,
      2.218389,
      26,
      2,
      17,
      NULL,
      NULL,
      NULL,
      '11- 6-1982',
      NULL,
      5,
      ' 9-17-1998',
      0,
      9.360402,
      16,
      NULL,
      2.075408,
      NULL,
      NULL,
      NULL,
      1.204851,
      19,
      3.631181,
      1.224247,
      8.542026,
      9,
      1.566496,
      11,
      NULL,
      0,
      ' 0- 8-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.222160,
      ' 2- 5-1978',
      NULL,
      NULL,
      NULL,
      11,
      '10-23-1998',
      6,
      ' 4-13-1976',
      NULL,
      7,
      ' 5- 9-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      27.334637,
      ' 4- 6-1982',
      52,
      NULL,
      20,
      ' 2- 0-1977',
      NULL,
      8.262522,
      ' 8-24-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


