set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9502500';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2032',
      '03140020',
      '20341430',
      NULL,
      '10004140',
      '04332441',
      NULL,
      '23340404',
      '03114003',
      '14031430',
      '31322301',
      '24100211',
      NULL,
      NULL,
      '04341321',
      '34403003',
      '44120323',
      '40244032',
      '03040011',
      '33234413',
      '33424140',
      '01442124',
      NULL,
      '32031022',
      '31013211',
      '13302103',
      '03433314',
      '13424110',
      '02142104',
      '02303133',
      NULL,
      '23424430',
      '34221040',
      '20223034',
      '02224321',
      NULL,
      '04141243',
      NULL,
      '33012323',
      '21300411',
      '12023422',
      '13014322',
      '20411301',
      '00210214',
      '13043233',
      '242',
      '04',
      NULL,
      NULL,
      '0010021',
      1.815064,
      0,
      0,
      NULL,
      '424142',
      5,
      '10- 4-1980',
      '11-23-1986',
      27.064310,
      NULL,
      13.941948,
      20.467584,
      10.197972,
      12.192013,
      8.697375,
      23.788900,
      21.572990,
      12.497740,
      9.222632,
      10.973816,
      29.621828,
      18.296447,
      14,
      9,
      8,
      17.095768,
      44,
      19.623316,
      59,
      11,
      70.592112,
      NULL,
      NULL,
      64.042338,
      27,
      20.975450,
      NULL,
      7,
      179,
      ' 1- 0-1986',
      9.549891,
      NULL,
      0.253407,
      3,
      85,
      109.745665,
      ' 2-21-1999',
      1.153947,
      2,
      4,
      2,
      2.916933,
      NULL,
      1.119649,
      1.494591,
      0.735203,
      NULL,
      3,
      1,
      1,
      1.096744,
      0,
      1,
      0,
      NULL,
      0.331983,
      0.335293,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-28-1995',
      39.747741,
      37.634808,
      NULL,
      6.453247,
      30.611004,
      NULL,
      ' 0-23-1983',
      1,
      0.928266,
      63.188636,
      0.287247,
      1,
      58.493674,
      0,
      0,
      37.617546,
      NULL,
      NULL,
      NULL,
      '11- 8-1988',
      NULL,
      51.386578,
      5,
      65.527012,
      99.839431,
      91.602737,
      80,
      35.306660,
      9.933219,
      47,
      25.061658,
      38.510951,
      ' 3- 5-1989',
      NULL,
      10.694313,
      NULL,
      30,
      NULL,
      46,
      NULL,
      NULL,
      24,
      NULL,
      ' 5- 0-2002',
      NULL,
      2,
      0.383396,
      NULL,
      4,
      NULL,
      1,
      1,
      NULL,
      53,
      0,
      3,
      0,
      0,
      NULL,
      3,
      0,
      0,
      '10-24-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      1.966649,
      NULL,
      ' 5-17-1983',
      NULL,
      NULL,
      NULL,
      25,
      NULL,
      46,
      NULL,
      NULL,
      9,
      ' 7-27-2003',
      NULL,
      75.737466,
      NULL,
      13.936879,
      6,
      ' 5-13-2001',
      NULL,
      NULL,
      NULL,
      2,
      1,
      16.871346,
      ' 6-29-1977',
      NULL,
      0.009487,
      19,
      NULL,
      NULL,
      155.176473,
      ' 2-22-1997',
      8.577841,
      NULL,
      20.244376,
      59.724476,
      ' 7-25-1987',
      37.901711,
      0.672304,
      158,
      ' 6-22-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


