set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9502500';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2343',
      '03344412',
      '32411131',
      '10411111',
      '10211313',
      '31334301',
      NULL,
      '40144414',
      NULL,
      '34111004',
      NULL,
      '12411442',
      '13440010',
      '30010133',
      '42403034',
      NULL,
      '22411114',
      '30123210',
      '44132111',
      '11140003',
      '14113324',
      NULL,
      '23412413',
      '42202431',
      '41144014',
      '23202200',
      '14143413',
      '12002044',
      '11114432',
      '22220200',
      '21003213',
      NULL,
      '34020320',
      '34424311',
      NULL,
      '40014011',
      '00103403',
      '33303333',
      '00423203',
      NULL,
      '44032330',
      '43124112',
      '12401233',
      '43114214',
      '13113311',
      NULL,
      '22',
      13,
      0.592483,
      '3102122',
      1,
      35,
      2,
      NULL,
      '130340',
      3,
      ' 8-26-1988',
      '11-26-1995',
      6.770147,
      NULL,
      15.522001,
      16,
      0.252515,
      6.631590,
      67.104169,
      12,
      0,
      NULL,
      9,
      NULL,
      14,
      NULL,
      16.462484,
      11,
      1,
      12,
      53.746412,
      22,
      62,
      8,
      97,
      9,
      1,
      NULL,
      42.812576,
      56,
      123.837381,
      NULL,
      27.223570,
      ' 0- 1-1998',
      40.635376,
      5,
      5.003907,
      17,
      NULL,
      NULL,
      ' 1-29-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      55.707788,
      36.540233,
      0.994583,
      28.567783,
      25,
      0,
      NULL,
      NULL,
      5,
      31.682303,
      0,
      0,
      141,
      NULL,
      NULL,
      47,
      NULL,
      NULL,
      NULL,
      '10-29-1976',
      70.032486,
      112,
      50,
      23.339038,
      NULL,
      72,
      106,
      105,
      91,
      22.335229,
      109.745838,
      7.324408,
      ' 1-16-1990',
      21.259493,
      13.373592,
      NULL,
      NULL,
      34,
      25.137058,
      6.126032,
      ' 5- 2-1986',
      1.940562,
      NULL,
      ' 3-20-1981',
      8,
      0.181453,
      13.047055,
      NULL,
      11.441207,
      7,
      0,
      7.765926,
      1.069782,
      21,
      12,
      4,
      2.649930,
      23.061083,
      NULL,
      9.795721,
      NULL,
      NULL,
      ' 6- 6-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      37.593463,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22,
      NULL,
      26.522233,
      ' 3-22-1985',
      5,
      1,
      ' 4- 5-1980',
      19,
      18,
      ' 3-26-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      ' 2-16-1983',
      73.187273,
      NULL,
      16,
      ' 0-19-1997',
      1,
      132,
      ' 3- 4-1993',
      2,
      52.839171,
      NULL,
      71.569800,
      ' 1-19-1982',
      9.280033,
      1,
      NULL,
      ' 5- 7-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


