set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6452968';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '40111000',
      '04040440',
      NULL,
      NULL,
      NULL,
      NULL,
      '44013332',
      NULL,
      NULL,
      '41101342',
      '04421310',
      '21214200',
      '13213423',
      '00400434',
      '33413114',
      '33323310',
      '41430143',
      NULL,
      '22122120',
      '33144401',
      '14101132',
      '32042013',
      '20211133',
      NULL,
      '41211410',
      '03304242',
      '43010211',
      '01224314',
      NULL,
      '42301000',
      '41144444',
      '23321200',
      '21413004',
      '32011424',
      '40131220',
      '40033001',
      '12232312',
      '04411443',
      '30411301',
      '21324400',
      '00123011',
      '34423331',
      '43103200',
      '32230112',
      '',
      '',
      NULL,
      NULL,
      '3220024',
      1.246872,
      0,
      NULL,
      NULL,
      '320440',
      NULL,
      ' 5-18-1998',
      ' 1-16-1990',
      5,
      NULL,
      23.804189,
      7,
      NULL,
      3.651112,
      28.508534,
      12.636197,
      22,
      6.560896,
      NULL,
      10.221205,
      NULL,
      13.160597,
      4.326540,
      1.860014,
      19.233976,
      20.179294,
      74,
      10.562701,
      53,
      0.477276,
      46,
      18.354660,
      NULL,
      32,
      113,
      NULL,
      149,
      95,
      183,
      ' 9-12-1974',
      NULL,
      38.567713,
      25.615629,
      NULL,
      136.852246,
      137,
      ' 7- 2-1983',
      1,
      0.398198,
      2,
      2.672796,
      NULL,
      NULL,
      NULL,
      NULL,
      0.671900,
      0.858917,
      1,
      1.628448,
      0,
      3.371264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      71.799463,
      49,
      14.033462,
      4,
      6,
      75,
      NULL,
      39,
      68.913676,
      19.580126,
      119.151366,
      NULL,
      NULL,
      14,
      9,
      20,
      4,
      21,
      46.763169,
      10,
      NULL,
      5,
      5,
      '11-14-1991',
      2,
      24.146956,
      NULL,
      7.205018,
      NULL,
      11.249289,
      NULL,
      NULL,
      NULL,
      22.903416,
      NULL,
      1,
      21,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 3-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      4,
      8,
      NULL,
      NULL,
      NULL,
      ' 2-10-1991',
      16,
      1,
      3,
      NULL,
      '11- 1-2001',
      56,
      0.157720,
      89.650288,
      ' 8- 6-1978',
      NULL,
      NULL,
      NULL,
      10,
      42.152401,
      NULL,
      103.057779,
      99.914415,
      NULL,
      11,
      11,
      8.519765,
      10.992031,
      NULL,
      18.728062,
      1.222939,
      1,
      24,
      0.801577,
      2,
      NULL,
      1.748281,
      NULL,
      NULL,
      0.399824,
      0,
      146.429842,
      103.533869,
      NULL,
      51.695916,
      0,
      68,
      1,
      0,
      1,
      1.876413,
      1.970810,
      0.214775,
      98,
      55,
      40,
      2,
      26.055450,
      12.580188,
      NULL,
      3.316913,
      41,
      0.395954,
      NULL,
      5,
      23.004560,
      0.708166,
      NULL,
      0.935593,
      80,
      NULL,
      1,
      95,
      7,
      12.765107,
      18.120582,
      17.618163,
      87,
      NULL,
      77.140564,
      7.528622,
      NULL,
      0.435894,
      4.152333,
      0,
      0,
      NULL,
      3.803217,
      38,
      ' 9-21-1994',
      ' 9- 4-1984',
      ' 6- 3-1984',
      ' 4- 9-1994',
      ' 1-29-1987',
      ' 0-22-1986',
      ' 5-17-1991',
      NULL);
commit;
end;
/


