set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6452968';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0423',
      NULL,
      '22123002',
      '31110324',
      '13120103',
      '20112203',
      NULL,
      '23223301',
      '33024003',
      '14420034',
      NULL,
      NULL,
      '20440433',
      NULL,
      '13222240',
      NULL,
      NULL,
      '30102132',
      '32323310',
      '21043214',
      '44102432',
      '41432120',
      '34013441',
      NULL,
      NULL,
      NULL,
      NULL,
      '31213302',
      '24334111',
      '22324031',
      '23430133',
      '44440342',
      '42122014',
      '32424401',
      '42021011',
      '30431041',
      '12304000',
      '40332310',
      '40304111',
      NULL,
      NULL,
      '24330004',
      '10004014',
      '01210232',
      '12013132',
      '',
      '',
      NULL,
      NULL,
      '2122334',
      NULL,
      28.230741,
      NULL,
      NULL,
      '104321',
      0.015719,
      ' 1-18-2000',
      NULL,
      48.479462,
      NULL,
      38,
      NULL,
      34,
      6,
      NULL,
      17.046392,
      11,
      6,
      32,
      NULL,
      7.038388,
      15.736565,
      3.350169,
      12,
      9,
      8.778378,
      76,
      NULL,
      50,
      2,
      108,
      NULL,
      NULL,
      109.115163,
      NULL,
      43.560894,
      4.000186,
      81.008644,
      NULL,
      ' 7- 4-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.043364,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.694963,
      NULL,
      1,
      0,
      0,
      1.272886,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 9-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 5-1985',
      61,
      28.783217,
      12,
      107,
      71.256257,
      NULL,
      50,
      NULL,
      36,
      38,
      52.491896,
      39.647555,
      '11-11-1988',
      NULL,
      NULL,
      13.497489,
      88,
      82.292138,
      159.026948,
      9,
      ' 3-21-1974',
      11,
      2.510986,
      '11-17-1997',
      7.618235,
      NULL,
      13,
      0.449775,
      18,
      8.106306,
      NULL,
      23,
      NULL,
      19.789569,
      1.908027,
      0.273556,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-27-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      30,
      39.233174,
      NULL,
      0,
      44,
      ' 0-27-2003',
      1.899989,
      34.054937,
      1.392540,
      NULL,
      ' 8-28-1989',
      62,
      1,
      NULL,
      '11-19-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.567306,
      72,
      20,
      144,
      4.788438,
      NULL,
      NULL,
      26,
      8,
      NULL,
      0,
      1,
      NULL,
      0.709322,
      0,
      57,
      0,
      1,
      NULL,
      NULL,
      NULL,
      7,
      32.325562,
      NULL,
      NULL,
      1.892530,
      NULL,
      0,
      1,
      0.796231,
      1.707831,
      1,
      0,
      51.971437,
      17,
      45.104279,
      NULL,
      80.044070,
      76.985483,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.143699,
      54,
      1.769330,
      1,
      NULL,
      NULL,
      3.735616,
      25.403385,
      NULL,
      12,
      NULL,
      NULL,
      3,
      NULL,
      0.329388,
      NULL,
      0.319025,
      1,
      0,
      NULL,
      45,
      ' 2-21-1998',
      NULL,
      ' 3- 3-1991',
      NULL,
      ' 6- 0-1987',
      NULL,
      NULL,
      NULL);
commit;
end;
/


