set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9119247';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2420',
      NULL,
      '41324232',
      '11400220',
      NULL,
      '23040141',
      '34200104',
      '04424110',
      '14403402',
      '03321431',
      '02411242',
      NULL,
      '23314341',
      NULL,
      '01424021',
      NULL,
      '20400223',
      NULL,
      '32120232',
      '40030201',
      NULL,
      '22200234',
      NULL,
      NULL,
      '24122133',
      '30220034',
      '33121202',
      NULL,
      '01010314',
      '42110322',
      '43432202',
      NULL,
      NULL,
      '00123144',
      '42043014',
      NULL,
      NULL,
      '34230211',
      '01014120',
      NULL,
      '21110332',
      '43033121',
      NULL,
      '01144442',
      '41213133',
      '304',
      '02',
      NULL,
      NULL,
      NULL,
      0.383811,
      1,
      NULL,
      NULL,
      '240433',
      NULL,
      ' 9-19-1992',
      ' 9- 7-1993',
      1.351403,
      NULL,
      NULL,
      NULL,
      22,
      6.445802,
      18,
      19.851278,
      20,
      1.614592,
      30,
      NULL,
      NULL,
      NULL,
      13.642811,
      13,
      32.569617,
      14.201074,
      6.022473,
      2,
      39.754832,
      5,
      19.173893,
      17.787511,
      NULL,
      17.388425,
      159,
      69,
      137.468724,
      0.282315,
      198,
      NULL,
      37,
      61,
      11.348157,
      36.270499,
      147.964786,
      128.984807,
      ' 6-12-1974',
      0.180365,
      0,
      NULL,
      1.556861,
      0.663203,
      0.869826,
      1.214089,
      1.050206,
      1,
      0.297429,
      0,
      NULL,
      0.991155,
      1.190697,
      1.581722,
      1,
      0.803062,
      NULL,
      0,
      0.299381,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-24-1985',
      10.341640,
      34.527486,
      25.247757,
      NULL,
      9.543399,
      1.889612,
      ' 3- 5-1976',
      1,
      1,
      220,
      NULL,
      3.381692,
      21.816143,
      NULL,
      1.957669,
      131,
      0.494062,
      1.521180,
      NULL,
      ' 4-21-1996',
      92,
      87.418775,
      148.224255,
      138,
      NULL,
      68,
      28,
      26.895639,
      76.259508,
      39.439386,
      61,
      98,
      NULL,
      3.715538,
      12,
      NULL,
      39.976203,
      87,
      115.679189,
      0,
      '10-26-1987',
      16.067707,
      10,
      NULL,
      9,
      NULL,
      NULL,
      0,
      15.657972,
      18.199126,
      1.715669,
      22,
      NULL,
      109.901714,
      NULL,
      NULL,
      13.695544,
      18.851620,
      2,
      2,
      1.513966,
      NULL,
      ' 1- 0-1985',
      3,
      2,
      NULL,
      ' 4- 6-1998',
      71,
      5,
      ' 4-24-1976',
      65,
      NULL,
      '11-23-1975',
      NULL,
      ' 8-17-1983',
      20.192106,
      ' 3-20-2000',
      19,
      15,
      ' 2-17-1991',
      47.535558,
      24,
      ' 0-23-1977',
      0,
      1,
      '10-14-1990',
      4.129580,
      5,
      ' 6-13-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      41,
      29.271755,
      ' 4- 2-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.245397);
commit;
end;
/


