set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9703349';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1443',
      '10232432',
      '42404324',
      '20241301',
      '32241333',
      '10432211',
      '41210331',
      '21404110',
      '13431302',
      NULL,
      '12021403',
      '11013444',
      '30232122',
      NULL,
      '41212334',
      NULL,
      NULL,
      '04102202',
      '12302122',
      NULL,
      '34412324',
      '00414233',
      '24110440',
      NULL,
      '13232000',
      NULL,
      '12204022',
      '00132433',
      '34000000',
      '42041214',
      NULL,
      '14001200',
      '00424031',
      '32003300',
      '41014240',
      '33141242',
      '23302411',
      '33211432',
      '03104344',
      NULL,
      '21343214',
      '43333401',
      '02013111',
      '44322211',
      '04120042',
      '233',
      NULL,
      NULL,
      11,
      '3001212',
      3.668126,
      NULL,
      1,
      NULL,
      '440222',
      2.088064,
      '11- 9-1986',
      ' 6-25-2001',
      NULL,
      12,
      NULL,
      25.511886,
      1.393903,
      NULL,
      12.333403,
      0.969243,
      4.560095,
      5.246479,
      38,
      0.455265,
      42,
      NULL,
      19,
      20,
      NULL,
      19.049429,
      NULL,
      19,
      NULL,
      3.357779,
      87.396557,
      NULL,
      1,
      NULL,
      21.252733,
      93,
      NULL,
      188,
      179.183025,
      NULL,
      6,
      NULL,
      7.553218,
      9.159171,
      49.997488,
      58,
      ' 8- 3-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      0,
      NULL,
      3.349830,
      1.034525,
      '10-15-1992',
      1.723435,
      0,
      153,
      NULL,
      0.967932,
      42,
      1.124988,
      1,
      61,
      NULL,
      NULL,
      NULL,
      NULL,
      74.331990,
      52,
      67.868268,
      NULL,
      6.199927,
      72.063475,
      67,
      57,
      20,
      7,
      63.642057,
      66,
      '11-22-1984',
      2.368913,
      NULL,
      13,
      NULL,
      25,
      9,
      5.412798,
      ' 9-24-1979',
      22.202396,
      1.221896,
      ' 2-22-1995',
      5.254065,
      3,
      NULL,
      16.903578,
      7.415318,
      11,
      1.199593,
      11,
      1.080597,
      107.514237,
      2,
      NULL,
      19,
      6,
      1.662433,
      1,
      NULL,
      NULL,
      ' 4- 2-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      3.602146,
      ' 5-24-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 2-1974',
      49.485019,
      ' 0-18-1982',
      NULL,
      NULL,
      ' 0- 0-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      13.703837,
      ' 8-13-2002',
      50.332778,
      29.767580,
      NULL,
      '10-10-1986',
      0.400816,
      58.969072,
      ' 7-17-1978',
      NULL,
      13,
      1.078439,
      43.991564,
      ' 4- 2-2002',
      53.514183,
      1,
      185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


