set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9703349';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '3',
      '1',
      '0',
      '4',
      '4',
      '2',
      '0',
      '2',
      '4',
      '1',
      '3',
      '2',
      '1',
      '2',
      '1',
      '3',
      '1',
      '2',
      '4',
      '0',
      '4',
      '0',
      '0',
      NULL,
      '3',
      '',
      '2',
      '0',
      NULL,
      '3',
      '3',
      '',
      NULL,
      '3',
      '2',
      '1',
      '0',
      '3',
      '4',
      '4',
      '1',
      '1',
      '1',
      '4',
      '433',
      '04312412',
      15,
      38,
      '2213304',
      3,
      21,
      2,
      NULL,
      '243222',
      3,
      ' 4-14-1988',
      ' 6-13-1990',
      40,
      61,
      45,
      6.685453,
      14,
      8.901869,
      82,
      NULL,
      NULL,
      25,
      NULL,
      6.757263,
      5.920639,
      17,
      35.182077,
      NULL,
      10.678448,
      5.415085,
      63.128945,
      12,
      73.363496,
      NULL,
      16.806662,
      14,
      0.097555,
      102.734758,
      NULL,
      95,
      107,
      118.304297,
      0.445902,
      ' 8- 6-1989',
      6.001825,
      5.516099,
      18,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14.886063,
      NULL,
      1.448718,
      9.879390,
      1,
      9,
      ' 9-19-1990',
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      19,
      NULL,
      NULL,
      NULL,
      ' 4-16-1986',
      68,
      79.207154,
      40.815752,
      2,
      8.597811,
      69.181334,
      23,
      61.009096,
      21.415944,
      23.475213,
      21,
      36.056207,
      ' 0- 9-1982',
      5.747611,
      9,
      7.336373,
      64,
      17,
      95.354996,
      2,
      ' 9-13-1977',
      5.219469,
      16.638124,
      ' 8-12-1989',
      NULL,
      17,
      14,
      NULL,
      2,
      5.678939,
      NULL,
      NULL,
      0.489859,
      4,
      1.667741,
      1.742343,
      5.096454,
      NULL,
      1.950276,
      1,
      NULL,
      1,
      ' 0-28-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.373861,
      ' 1-26-1983',
      NULL,
      NULL,
      NULL,
      50,
      ' 8-19-1993',
      NULL,
      ' 0-16-1987',
      0.143233,
      10.628575,
      ' 3- 1-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      23.909026,
      ' 2-14-1996',
      53.517896,
      44,
      38.489815,
      ' 3-28-1983',
      0.345737,
      60,
      ' 9-12-1993',
      2.459865,
      15,
      7,
      56,
      ' 1- 4-1979',
      NULL,
      NULL,
      161.225828,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


