set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9703349';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '2',
      '1',
      '4',
      '1',
      '3',
      '3',
      '1',
      '0',
      '2',
      NULL,
      '4',
      NULL,
      '0',
      '0',
      '4',
      '0',
      '3',
      '0',
      '1',
      NULL,
      NULL,
      '1',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '4',
      NULL,
      '1',
      '0',
      '',
      '',
      '0',
      '1',
      '2',
      '4',
      '1',
      NULL,
      '1',
      '4',
      '0',
      '2',
      '4',
      '004',
      NULL,
      NULL,
      55.134260,
      '2101323',
      1,
      115,
      3,
      0,
      '130220',
      2.399728,
      NULL,
      ' 8-17-1996',
      103,
      44.398890,
      20,
      13,
      NULL,
      7,
      21,
      12.135754,
      23.461731,
      9,
      33.056774,
      0,
      3.771324,
      0,
      27,
      13,
      14.257604,
      2.967550,
      NULL,
      NULL,
      79,
      0.683395,
      67,
      8,
      NULL,
      14,
      103.725423,
      15.699646,
      157.226727,
      28.778148,
      106.645306,
      ' 4-19-1989',
      21,
      36,
      14.932807,
      32.327414,
      NULL,
      NULL,
      '11- 9-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      39.880466,
      1,
      5.142445,
      5.583331,
      0.813869,
      2.951161,
      ' 5-16-1979',
      1.412934,
      1.089063,
      79,
      1,
      3,
      NULL,
      3,
      1.142890,
      17,
      NULL,
      NULL,
      NULL,
      NULL,
      80,
      53,
      36,
      0.832236,
      75.124508,
      18.636215,
      NULL,
      73,
      NULL,
      24.933072,
      34.858452,
      52,
      NULL,
      14.792761,
      6.159761,
      4,
      47.345011,
      14,
      NULL,
      11.569607,
      NULL,
      3.140960,
      14,
      ' 1-29-1975',
      1.567027,
      12.232325,
      NULL,
      2.809539,
      4,
      0.047391,
      1,
      7,
      1,
      97,
      7.517334,
      0,
      5,
      10,
      1,
      4.773057,
      NULL,
      NULL,
      ' 3-17-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      121.395414,
      NULL,
      ' 3- 4-1981',
      NULL,
      NULL,
      NULL,
      51.755941,
      NULL,
      5,
      NULL,
      NULL,
      3,
      ' 1-25-1996',
      36,
      48.319617,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      ' 6- 8-1988',
      57,
      23,
      26,
      ' 9-22-1982',
      0.941649,
      NULL,
      '11-23-1988',
      NULL,
      0,
      NULL,
      16.649288,
      ' 8- 0-1976',
      41.356439,
      1,
      NULL,
      ' 1-23-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


