set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8212287';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1214',
      '33234323',
      '00334110',
      NULL,
      '01111140',
      '03411313',
      '20312223',
      '21230014',
      '04100002',
      '11234444',
      '30441233',
      '42114010',
      '24411123',
      NULL,
      '03311241',
      '24432101',
      '32134410',
      NULL,
      '30013230',
      '11133431',
      NULL,
      '22034231',
      NULL,
      '30132020',
      '30410313',
      '40431411',
      '02041443',
      '20301344',
      '42033340',
      '33022233',
      NULL,
      '12141032',
      '42301120',
      '14322114',
      '03010403',
      '20002213',
      '30130123',
      '14021414',
      NULL,
      '13103012',
      NULL,
      '22010242',
      NULL,
      '00332024',
      '43002330',
      '',
      '',
      NULL,
      NULL,
      '3112400',
      1,
      14.289785,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-18-1990',
      '10- 8-1977',
      25,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      62.747740,
      44.656370,
      18.241632,
      14.662762,
      NULL,
      41.033202,
      ' 5- 7-1976',
      NULL,
      0.877054,
      0.532828,
      1.413955,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.215324,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-22-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 2-1977',
      64.000710,
      44.792371,
      78,
      4.910332,
      88,
      92,
      NULL,
      11,
      58.315129,
      NULL,
      NULL,
      68,
      ' 7-24-1977',
      32,
      NULL,
      0,
      40.517286,
      51,
      24,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      2.912089,
      16.693336,
      6,
      1.457679,
      5.443998,
      0,
      NULL,
      8,
      NULL,
      NULL,
      2,
      NULL,
      2.624249,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-17-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.365516,
      7,
      ' 8-19-1993',
      NULL,
      NULL,
      NULL,
      86.174804,
      0,
      1,
      60,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      32,
      0,
      NULL,
      41.832907,
      1,
      NULL,
      NULL,
      NULL,
      1.833856,
      125,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.137693,
      9,
      1.824577,
      0.759876,
      NULL,
      7.026536,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      19,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.720640,
      4,
      1.056820,
      0.124416,
      1.891407,
      5,
      0.655307,
      5.484474,
      43,
      NULL,
      NULL,
      NULL,
      ' 2-12-1980',
      NULL,
      NULL,
      ' 4- 4-1989',
      NULL);
commit;
end;
/


