set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8212287';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0134',
      '31424142',
      NULL,
      '43002402',
      '24234124',
      '03421010',
      '11140112',
      '01321040',
      '43112212',
      '41034314',
      '30444433',
      '02200323',
      NULL,
      '33412444',
      '30420234',
      '01402424',
      '44433043',
      '21420322',
      '31214243',
      '00340123',
      '44034203',
      '03142430',
      '11224011',
      '40121443',
      '23432312',
      '40230232',
      '40012210',
      '43403122',
      NULL,
      NULL,
      NULL,
      '10031003',
      '30140224',
      '30224032',
      '12231333',
      '30030424',
      NULL,
      '00100311',
      '30304311',
      '12310031',
      '44402414',
      '01341032',
      NULL,
      NULL,
      '30421214',
      '004',
      '41',
      NULL,
      NULL,
      '2002234',
      1,
      81.309004,
      0,
      NULL,
      '113002',
      2,
      ' 0-20-1980',
      ' 8- 7-1997',
      NULL,
      NULL,
      NULL,
      21.789183,
      7,
      15.464311,
      15,
      NULL,
      14,
      NULL,
      28,
      16,
      27,
      0,
      NULL,
      9.655534,
      25.062224,
      7,
      60.737575,
      NULL,
      NULL,
      15.447992,
      3,
      3.066521,
      NULL,
      17,
      197,
      80,
      1,
      50,
      68.309981,
      ' 4-12-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      1.716711,
      1,
      3,
      0.913140,
      0.688109,
      1.618771,
      1,
      1.612417,
      1.493196,
      NULL,
      1.864432,
      0.922732,
      0.076404,
      1,
      0.660719,
      1.429926,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-29-1977',
      96,
      17,
      8,
      0.577018,
      NULL,
      3.327849,
      ' 2-13-1983',
      1.075667,
      0.242680,
      NULL,
      1.221764,
      1.916631,
      NULL,
      0.642876,
      1.529783,
      66,
      1.166388,
      0.624680,
      23.052369,
      ' 8- 3-2001',
      NULL,
      33.912098,
      53.516812,
      77.095162,
      1.082600,
      63.543624,
      49.427271,
      83.815721,
      2.247467,
      61.053418,
      104,
      NULL,
      '10- 3-1979',
      3.059438,
      25,
      7.716400,
      43,
      50,
      166.463329,
      10,
      NULL,
      27.933053,
      NULL,
      ' 7- 7-1989',
      7.726953,
      4.102665,
      10.556631,
      4.804909,
      12.840299,
      1,
      NULL,
      NULL,
      0,
      68.784578,
      3,
      3.900738,
      1,
      25.006808,
      2.963131,
      0.563124,
      NULL,
      NULL,
      '10- 2-2001',
      4,
      6.634763,
      NULL,
      ' 7- 8-1984',
      50,
      NULL,
      ' 7- 0-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 8-1985',
      41.187563,
      ' 1- 5-1998',
      19.734608,
      NULL,
      NULL,
      116,
      79,
      ' 9-28-1997',
      NULL,
      1.487467,
      ' 9-29-1991',
      8,
      27,
      ' 3-24-1996',
      0,
      3,
      5.522221,
      ' 5-25-1985',
      60,
      NULL,
      29.773836,
      NULL,
      1,
      23.309581,
      ' 9- 9-2003',
      16,
      NULL,
      19,
      18,
      ' 3-19-1979',
      66.931773,
      0,
      28,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14);
commit;
end;
/


