set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8212287';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '11422314',
      '12302404',
      '22224204',
      '13302024',
      NULL,
      '23001400',
      NULL,
      '30044020',
      '20303102',
      '12034332',
      '03112100',
      '04132133',
      '20114123',
      '42103401',
      NULL,
      '13102314',
      '30143124',
      '03430312',
      '21402431',
      '33000333',
      '33104113',
      '10020112',
      '01122242',
      '23042413',
      '42421310',
      '24330200',
      '22234421',
      '13021433',
      '03201041',
      '14344031',
      '32432411',
      '01130210',
      '12231400',
      NULL,
      NULL,
      '42043043',
      NULL,
      '11421203',
      '21103102',
      '33013031',
      NULL,
      NULL,
      NULL,
      NULL,
      '214',
      NULL,
      33,
      1,
      '2432340',
      2.201864,
      48,
      NULL,
      NULL,
      NULL,
      2,
      ' 8-16-2000',
      ' 9- 7-2002',
      NULL,
      68,
      38.655668,
      13.247156,
      NULL,
      7.831644,
      90.615755,
      NULL,
      NULL,
      NULL,
      14.081815,
      16.796187,
      4.945510,
      7,
      23,
      28.956594,
      2.007661,
      NULL,
      9,
      5.695357,
      2.027433,
      10,
      55,
      0.812666,
      0.539332,
      71.590206,
      84,
      76,
      189.270193,
      105.055795,
      129.127141,
      NULL,
      10,
      35.065162,
      NULL,
      26.766421,
      129,
      234.384956,
      ' 1- 1-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      62,
      NULL,
      0,
      2.013293,
      8,
      9,
      '10-27-1977',
      NULL,
      1.229912,
      NULL,
      1,
      0.020660,
      70.330785,
      NULL,
      1.848830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.053204,
      16.386865,
      16,
      NULL,
      36,
      52,
      7.810263,
      NULL,
      27.976047,
      41.658819,
      NULL,
      61.180223,
      ' 9- 9-2002',
      7,
      4.894558,
      10.326525,
      32.968762,
      NULL,
      29,
      3.868596,
      NULL,
      NULL,
      NULL,
      ' 0-12-2000',
      6,
      16.862061,
      5,
      5,
      5,
      7.027448,
      1.001561,
      NULL,
      1,
      6.461882,
      6.661340,
      3.129373,
      NULL,
      NULL,
      NULL,
      NULL,
      0.521283,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      29.170124,
      1.593770,
      ' 1-27-1974',
      NULL,
      NULL,
      NULL,
      35.091867,
      '10-15-1997',
      5.133638,
      ' 3- 2-1984',
      5,
      NULL,
      ' 3-29-2001',
      112,
      69.965809,
      ' 1- 5-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      ' 0- 2-1996',
      35.705390,
      NULL,
      16,
      NULL,
      1.286267,
      154,
      ' 5- 1-1988',
      0,
      0.811195,
      18.752869,
      28.857519,
      ' 8-12-1978',
      NULL,
      0.463334,
      7.458753,
      '11- 9-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


