set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8212287';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      NULL,
      NULL,
      '1',
      '2',
      '4',
      NULL,
      '2',
      '1',
      '4',
      NULL,
      '2',
      '0',
      '4',
      '4',
      '2',
      '3',
      '1',
      '1',
      '0',
      '3',
      '3',
      NULL,
      NULL,
      '',
      '1',
      NULL,
      '0',
      '1',
      NULL,
      '4',
      '0',
      '',
      '',
      '1',
      '0',
      '2',
      '4',
      '3',
      '4',
      '2',
      NULL,
      '1',
      '4',
      '2',
      NULL,
      '42410133',
      64,
      31,
      '0411200',
      3.869777,
      NULL,
      3,
      NULL,
      '413324',
      1,
      ' 5-16-1982',
      ' 3-28-1986',
      73,
      40,
      20.387793,
      5.969689,
      NULL,
      15.876427,
      84.051763,
      NULL,
      0.690199,
      19,
      5,
      NULL,
      9,
      23.803528,
      28.831758,
      NULL,
      26.531584,
      4.571394,
      30,
      24,
      29.798912,
      2,
      NULL,
      24.258779,
      NULL,
      27.360692,
      NULL,
      47,
      74.939076,
      125,
      12,
      ' 6-29-1982',
      45.019970,
      NULL,
      37,
      28,
      185.278567,
      96.395015,
      ' 9- 1-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      29,
      2,
      0.110682,
      4.631837,
      NULL,
      2,
      ' 9- 2-1981',
      0,
      NULL,
      4,
      3,
      1,
      77.144550,
      0.206339,
      1.030591,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-29-2002',
      32,
      81.372704,
      53.168728,
      83.138942,
      18,
      NULL,
      17.800594,
      29.515816,
      31,
      45.473763,
      41,
      29.856259,
      ' 1-23-1994',
      16.606774,
      2.755702,
      19,
      53,
      NULL,
      24.594246,
      8.771231,
      ' 7-15-1994',
      NULL,
      7,
      ' 4-11-1998',
      2,
      7.234718,
      10.497871,
      NULL,
      5.972109,
      1,
      NULL,
      5.671318,
      0.117308,
      0,
      1.119466,
      1,
      4.271952,
      NULL,
      2.377920,
      7,
      1.865504,
      0,
      ' 9- 0-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      169.249417,
      9.146519,
      ' 0-11-1988',
      NULL,
      NULL,
      NULL,
      28.623564,
      '10- 4-1978',
      20,
      ' 4-22-1998',
      NULL,
      1,
      ' 9-20-1974',
      123,
      47.015157,
      ' 2- 6-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      ' 7- 1-1974',
      59,
      15,
      28,
      ' 2-28-1995',
      NULL,
      5.479173,
      ' 8- 9-1977',
      4,
      21.469229,
      5,
      16.515094,
      ' 5-25-1979',
      69,
      NULL,
      10,
      ' 8-12-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


