set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9504131';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '0',
      '2',
      '1',
      NULL,
      '0',
      '0',
      '4',
      '3',
      NULL,
      NULL,
      '2',
      NULL,
      '4',
      '0',
      '2',
      NULL,
      '2',
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      '3',
      NULL,
      '0',
      '',
      '2',
      NULL,
      '1',
      '2',
      '2',
      NULL,
      '',
      '0',
      '3',
      '3',
      '4',
      '3',
      NULL,
      '3',
      '0',
      '3',
      '2',
      NULL,
      '103',
      NULL,
      NULL,
      17,
      '0330143',
      3,
      0.988684,
      1,
      0,
      '041443',
      2.470387,
      ' 4-19-1978',
      ' 4-18-1976',
      27,
      NULL,
      NULL,
      9,
      6.489285,
      21.334705,
      91.307518,
      12,
      NULL,
      23,
      29,
      0,
      NULL,
      NULL,
      NULL,
      7.897049,
      NULL,
      NULL,
      56.635729,
      17,
      0.565819,
      5.994180,
      68.484502,
      NULL,
      1,
      74.512123,
      110,
      5,
      165,
      226.095252,
      46.448905,
      NULL,
      25,
      16.919015,
      27.098918,
      NULL,
      21,
      NULL,
      ' 7-27-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      38,
      5,
      NULL,
      NULL,
      9,
      8,
      NULL,
      1,
      1,
      NULL,
      0.185033,
      0.306596,
      112,
      NULL,
      1.120849,
      32,
      NULL,
      NULL,
      NULL,
      ' 5- 5-1977',
      38.859282,
      NULL,
      101,
      NULL,
      75.886732,
      86,
      41,
      76.024408,
      49.878938,
      NULL,
      NULL,
      81,
      ' 4-19-1992',
      3.366435,
      25.821286,
      NULL,
      73.655932,
      21.832323,
      122,
      8,
      NULL,
      14,
      19.062352,
      ' 0-14-2002',
      7,
      9.960497,
      NULL,
      NULL,
      3.544242,
      5.231558,
      1.182484,
      0.895563,
      0.705976,
      16.368563,
      0.714907,
      0.501827,
      11,
      27.582239,
      0.311285,
      0.270806,
      1.281422,
      NULL,
      ' 9-23-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      20,
      5,
      ' 0-13-1991',
      NULL,
      NULL,
      NULL,
      32.182073,
      '11-21-1998',
      33.604668,
      ' 5-15-1992',
      NULL,
      17,
      ' 4-29-1974',
      60.686643,
      57.369698,
      ' 8-26-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      18,
      ' 9- 3-2002',
      32.731834,
      44,
      45,
      ' 9-10-1982',
      1.501805,
      37.023015,
      ' 2-12-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


