set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8633509';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2040',
      '30200414',
      NULL,
      '14131244',
      '12044330',
      '14404114',
      '20044112',
      '33210130',
      '01310001',
      '43001134',
      '02221422',
      '21411443',
      '22241332',
      NULL,
      NULL,
      NULL,
      '31040344',
      '02203134',
      '42423341',
      '13314122',
      '04443310',
      '12133410',
      '30042304',
      '44201432',
      '33421044',
      '44134341',
      '42313323',
      NULL,
      '32322234',
      '40143241',
      '01013403',
      '31131143',
      '21404242',
      '24203233',
      '34303422',
      NULL,
      '11141240',
      '41044421',
      '24224122',
      '00332102',
      '40200012',
      '20333010',
      NULL,
      '04314223',
      '10411431',
      '',
      '',
      NULL,
      NULL,
      '2233214',
      NULL,
      1.835814,
      2,
      NULL,
      '342131',
      2.488586,
      NULL,
      ' 9-29-1988',
      24,
      NULL,
      30,
      NULL,
      NULL,
      NULL,
      103,
      18,
      NULL,
      NULL,
      48,
      20.104849,
      5.032059,
      3.344569,
      NULL,
      3,
      14.172675,
      16.439162,
      22.703562,
      NULL,
      51,
      20.873526,
      106,
      23,
      NULL,
      5.371884,
      61,
      15,
      106,
      NULL,
      122.611893,
      ' 9- 9-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3.589994,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.495062,
      1.490168,
      1.391360,
      1.242434,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-13-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.142049,
      12,
      12.089918,
      NULL,
      NULL,
      NULL,
      5,
      ' 3-29-1975',
      NULL,
      5.959630,
      ' 6-25-1985',
      4.695683,
      17.774501,
      18.259527,
      11,
      4.683166,
      15.855594,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.166380,
      7.083214,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      66.470316,
      23,
      3,
      ' 2-27-1983',
      1,
      33.586157,
      ' 0-15-1986',
      NULL,
      NULL,
      1,
      45,
      NULL,
      53.840156,
      1,
      145.245376,
      '10- 8-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.080751,
      NULL,
      NULL,
      78,
      59.903483,
      33.193676,
      18.861506,
      33.277307,
      NULL,
      NULL,
      0,
      NULL,
      60,
      NULL,
      NULL,
      30,
      0,
      1.789966,
      28,
      NULL,
      5.926808,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.745968,
      0,
      1.743952,
      0.146162,
      0,
      0,
      NULL,
      NULL,
      NULL,
      25,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.719817,
      NULL,
      NULL,
      0.912271,
      NULL,
      35,
      5,
      21.710128,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      0.465336,
      1,
      0.866265,
      2,
      NULL,
      NULL,
      NULL,
      ' 7-25-1993',
      NULL,
      NULL,
      NULL,
      ' 8-26-1977',
      NULL);
commit;
end;
/


