set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9648262';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1040',
      '22433414',
      '22340434',
      '11401324',
      '30430422',
      '32111240',
      NULL,
      '30013442',
      NULL,
      '13212244',
      '14341130',
      '04443000',
      '03233331',
      '44443043',
      '22413230',
      '44300103',
      '20310101',
      '30120003',
      '34111014',
      '24421001',
      NULL,
      '02114100',
      '12401141',
      NULL,
      '04314143',
      NULL,
      '23104022',
      NULL,
      '21244431',
      '24421222',
      '44332133',
      NULL,
      '41221042',
      '04312414',
      '03422234',
      '33441032',
      '21132341',
      '21001123',
      NULL,
      '04200434',
      '42243023',
      NULL,
      '44342241',
      '22032204',
      '01423040',
      '122',
      '32',
      26.701697,
      12.829527,
      NULL,
      3,
      0.376489,
      1,
      NULL,
      '204034',
      5.237460,
      ' 8- 4-1982',
      NULL,
      37.527528,
      18,
      15,
      NULL,
      9.117710,
      11.463133,
      40.289098,
      NULL,
      17.006416,
      7,
      7.359737,
      1.974813,
      NULL,
      19.348308,
      NULL,
      17.226503,
      NULL,
      7,
      NULL,
      3,
      18,
      2,
      NULL,
      1,
      NULL,
      24.174806,
      82,
      65.693682,
      153,
      42,
      79.679005,
      ' 8-27-1977',
      35.349618,
      28,
      21.122128,
      7,
      114,
      68,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.613314,
      NULL,
      0,
      4.241766,
      NULL,
      0,
      0,
      118,
      0.620878,
      1,
      NULL,
      1,
      1,
      50.125760,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      100,
      14.742366,
      1,
      80,
      NULL,
      85.545841,
      28.266055,
      84,
      21,
      16,
      97,
      ' 3-18-1975',
      13,
      NULL,
      2,
      0.656188,
      34,
      18.113096,
      3,
      ' 1- 9-1975',
      25,
      NULL,
      ' 4-17-1994',
      NULL,
      7.285966,
      4,
      10.668566,
      5.123852,
      3.883147,
      NULL,
      13.713167,
      1,
      69,
      0,
      0.973953,
      NULL,
      15,
      3,
      4.470702,
      1,
      NULL,
      ' 4-14-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      25.730330,
      ' 4- 1-1977',
      8.219527,
      ' 0-21-1979',
      NULL,
      7,
      ' 4-25-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      6.878803,
      ' 7-20-1981',
      24.287248,
      NULL,
      0,
      ' 5-10-1976',
      0,
      110,
      ' 7-17-1990',
      NULL,
      64,
      3,
      143.265750,
      ' 0- 1-1986',
      40,
      NULL,
      25,
      ' 4- 3-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


