set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9220323';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0343',
      '32343310',
      '10214130',
      '12222234',
      NULL,
      '33404314',
      NULL,
      '11022423',
      '04343012',
      NULL,
      '22013104',
      '34132003',
      '41331004',
      '43230323',
      '31410323',
      '03331010',
      '21021121',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '32431144',
      '43140144',
      '22220330',
      NULL,
      NULL,
      '40432412',
      '01221302',
      '00330022',
      NULL,
      '12311114',
      '23211014',
      '22112040',
      NULL,
      '00324333',
      '31443210',
      '41402300',
      '10133024',
      '24133324',
      NULL,
      '44243400',
      '20223241',
      '32341044',
      NULL,
      '342',
      NULL,
      NULL,
      NULL,
      '4342344',
      2,
      0,
      2,
      NULL,
      '120322',
      NULL,
      ' 4-15-1975',
      ' 7- 3-1994',
      51,
      NULL,
      26,
      NULL,
      3,
      1,
      53,
      NULL,
      7.839161,
      14.115560,
      NULL,
      4.130851,
      36.186383,
      1,
      25,
      NULL,
      30.948247,
      11.736437,
      NULL,
      19.481397,
      68.958205,
      0.460162,
      NULL,
      NULL,
      0,
      NULL,
      176.119977,
      48.620623,
      201,
      208.853892,
      189,
      ' 0-20-1984',
      47.949812,
      62.563504,
      13.713017,
      NULL,
      70,
      190,
      ' 3- 9-1976',
      0.660482,
      2,
      5,
      NULL,
      1,
      1,
      NULL,
      1.055423,
      0,
      1.711837,
      NULL,
      1.313943,
      NULL,
      0.430652,
      0.594466,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 5-2002',
      6,
      23.435259,
      4,
      9.629462,
      NULL,
      7.921391,
      '11-20-1981',
      NULL,
      1.509176,
      38,
      0.662292,
      0.041037,
      102,
      1.042009,
      NULL,
      34.773095,
      0.466542,
      2,
      NULL,
      NULL,
      133.623027,
      117.102608,
      NULL,
      43,
      NULL,
      83.417551,
      NULL,
      8,
      34,
      32,
      14.124012,
      2,
      ' 7-26-1984',
      4.788218,
      7.010165,
      21,
      34,
      97,
      135.414199,
      0,
      ' 2- 2-1985',
      1,
      5,
      ' 8-23-1997',
      NULL,
      2,
      15.991566,
      20,
      NULL,
      NULL,
      1,
      NULL,
      1.701596,
      83,
      0.254007,
      7,
      23,
      22,
      0,
      0,
      3,
      0.446427,
      '10-13-1994',
      5.935375,
      3,
      0,
      '11-11-1980',
      NULL,
      11,
      ' 6-17-1989',
      NULL,
      NULL,
      NULL,
      48.734800,
      NULL,
      NULL,
      ' 2- 8-1978',
      14,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-15-1992',
      5.237381,
      7.229503,
      ' 0-16-1991',
      1.276789,
      3.565026,
      ' 9- 9-1978',
      3,
      0,
      NULL,
      '10-21-2001',
      NULL,
      50,
      33.824751,
      ' 6-27-1989',
      NULL,
      NULL,
      ' 0- 6-2002',
      2,
      17.042849,
      16.527132,
      23,
      ' 8-28-1992',
      23.969913,
      1,
      55,
      ' 1- 2-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.683098);
commit;
end;
/


