set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9220323';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '2',
      '2',
      NULL,
      '1',
      '1',
      '3',
      NULL,
      '2',
      '2',
      '3',
      '2',
      '2',
      '1',
      '3',
      NULL,
      NULL,
      '0',
      '1',
      '3',
      '0',
      NULL,
      '3',
      '0',
      '',
      '0',
      '',
      '3',
      '4',
      '1',
      NULL,
      '2',
      '',
      '',
      NULL,
      '0',
      '4',
      '4',
      NULL,
      '0',
      '0',
      '0',
      '1',
      '4',
      '1',
      '211',
      '40341040',
      NULL,
      44.832002,
      '0441003',
      NULL,
      83,
      0,
      NULL,
      NULL,
      2.060823,
      ' 4-11-1981',
      ' 3-12-1980',
      0,
      106.006380,
      5.939890,
      11.584688,
      1.347311,
      12.751436,
      59.540987,
      7,
      NULL,
      10.526827,
      35,
      5.221089,
      7,
      7,
      NULL,
      4,
      NULL,
      20.913590,
      71,
      8,
      10,
      11.549979,
      NULL,
      19,
      NULL,
      5,
      33,
      NULL,
      39.926616,
      6,
      17,
      ' 8-16-1999',
      19.571205,
      70,
      0.944798,
      21,
      147,
      65,
      ' 1-23-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      106,
      8.146417,
      7,
      NULL,
      0,
      9,
      '11- 3-1997',
      NULL,
      1,
      196,
      1.036311,
      1.320825,
      3,
      1.091424,
      1,
      10.543185,
      NULL,
      NULL,
      NULL,
      ' 3- 2-2003',
      49.476854,
      48,
      17,
      45.282949,
      109.214248,
      54,
      19,
      63,
      74,
      60.154853,
      51,
      NULL,
      ' 2-29-1989',
      22.577581,
      NULL,
      11.643355,
      86,
      36.186026,
      106.168676,
      3.857961,
      NULL,
      21,
      6.539495,
      ' 3-21-1976',
      NULL,
      2.126573,
      NULL,
      14,
      8.071967,
      2,
      NULL,
      11.209458,
      0.929847,
      23.486000,
      1,
      1.098594,
      11.805561,
      24.324618,
      1.227575,
      0.091692,
      0.328374,
      0.288297,
      ' 9- 3-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      99.726060,
      0.837849,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      49,
      '10-20-1987',
      9.635351,
      7,
      ' 5- 1-1986',
      NULL,
      5,
      ' 8-12-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      16.677719,
      ' 8- 8-1976',
      26.873159,
      21.951169,
      4,
      ' 8-25-2001',
      1,
      18.381971,
      ' 0- 9-1981',
      19,
      24,
      6,
      33,
      '10-23-1986',
      NULL,
      1.878817,
      NULL,
      ' 8- 6-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


