set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9126231';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2342',
      '30043420',
      NULL,
      '42030214',
      '41314341',
      NULL,
      NULL,
      '04334022',
      '20101444',
      '11230404',
      '10444214',
      '03232402',
      '44441223',
      '30304043',
      '40200003',
      '01114201',
      '30302334',
      NULL,
      NULL,
      '43404132',
      '12333344',
      '24303324',
      NULL,
      '21313434',
      '00204242',
      NULL,
      '00404320',
      '40112013',
      '34402433',
      NULL,
      '22022003',
      '10442334',
      NULL,
      '04114113',
      NULL,
      NULL,
      '13031424',
      '02000433',
      '30321234',
      '31230300',
      '24140320',
      '31331021',
      '12121100',
      '22212323',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      '0001322',
      2.140312,
      1.206965,
      3,
      NULL,
      '314412',
      3.793314,
      ' 7-15-1989',
      ' 0-17-1986',
      102,
      NULL,
      NULL,
      17.971542,
      18,
      12,
      56.084754,
      NULL,
      14.468337,
      4.347435,
      20.409367,
      16.256229,
      37.105796,
      2.741967,
      NULL,
      3.327325,
      6.138806,
      NULL,
      33,
      11,
      40.529452,
      9.322820,
      30,
      6,
      NULL,
      85,
      12,
      59,
      NULL,
      168,
      59,
      ' 9- 4-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.115140,
      1.613729,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      NULL,
      1.256475,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-19-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      24.826045,
      38.234546,
      9.349746,
      84,
      2,
      8,
      NULL,
      23.750990,
      NULL,
      71,
      24,
      NULL,
      ' 5-14-1985',
      1,
      NULL,
      13,
      39,
      41.501199,
      11,
      8.398970,
      ' 7-12-1990',
      12.940351,
      2.757318,
      ' 3- 7-1977',
      7,
      NULL,
      11.593806,
      NULL,
      1.777102,
      NULL,
      NULL,
      11,
      NULL,
      29.621084,
      1,
      15,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-20-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      63.597607,
      16.635800,
      6,
      ' 9-17-1979',
      1.228324,
      43.174634,
      ' 3-25-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      40.116380,
      15,
      NULL,
      NULL,
      73,
      15.327299,
      10.054550,
      14,
      2,
      4.386149,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.281181,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      9,
      3.786010,
      NULL,
      0.756900,
      1,
      1.824932,
      1,
      NULL,
      ' 5-11-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


