set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9126231';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      NULL,
      '2',
      '3',
      '2',
      '3',
      '0',
      '0',
      '1',
      '0',
      '3',
      '4',
      '4',
      '0',
      '1',
      NULL,
      '2',
      '1',
      '1',
      NULL,
      '3',
      '0',
      '4',
      '2',
      '',
      '4',
      NULL,
      '3',
      '0',
      '0',
      '0',
      '0',
      '',
      '',
      NULL,
      '1',
      '2',
      '1',
      '1',
      '4',
      '1',
      '3',
      NULL,
      '4',
      '1',
      '242',
      NULL,
      14,
      41.119929,
      '4413331',
      0.916948,
      198.306487,
      2,
      NULL,
      '401431',
      3,
      ' 2- 1-2002',
      '10- 1-1983',
      NULL,
      69,
      27.801736,
      4.583896,
      NULL,
      4,
      25,
      9.526100,
      NULL,
      27,
      3.082412,
      13.437877,
      12.742973,
      2,
      NULL,
      11.198003,
      7,
      15,
      23.708082,
      10.213149,
      15,
      5.994722,
      27,
      NULL,
      NULL,
      NULL,
      149,
      18.483433,
      105.666678,
      149,
      166,
      ' 3- 6-1975',
      NULL,
      7,
      4.420732,
      31.339092,
      75.822309,
      20,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      51,
      20.777234,
      15,
      NULL,
      NULL,
      3.983058,
      ' 8-23-1978',
      0.888013,
      1.597265,
      182,
      0.202614,
      3,
      46,
      0,
      1.834974,
      4,
      NULL,
      NULL,
      NULL,
      ' 6- 8-1983',
      46,
      2,
      13,
      73.467710,
      63.657903,
      9,
      NULL,
      NULL,
      57,
      33,
      4.692039,
      73,
      '10-14-1976',
      14,
      NULL,
      NULL,
      55,
      2,
      10.164366,
      NULL,
      '11- 9-2000',
      NULL,
      2,
      ' 0- 6-1983',
      6.116019,
      9,
      15.097106,
      16,
      9,
      NULL,
      NULL,
      9,
      0.979110,
      11,
      NULL,
      NULL,
      0,
      11,
      3.983287,
      5.698882,
      1.130837,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.620037,
      NULL,
      NULL,
      NULL,
      NULL,
      42.141699,
      ' 5- 5-1981',
      NULL,
      ' 5-15-1998',
      11,
      NULL,
      '10- 7-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      ' 8- 7-1979',
      NULL,
      NULL,
      5.237972,
      ' 7-26-1995',
      1,
      136.409971,
      ' 3-23-1975',
      1.797165,
      NULL,
      6,
      NULL,
      ' 1-27-1998',
      NULL,
      0.359978,
      93.692898,
      '11-11-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


