set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9126231';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '0',
      '2',
      '0',
      NULL,
      '0',
      '2',
      NULL,
      '1',
      '1',
      '1',
      '4',
      '0',
      '2',
      '1',
      '3',
      '2',
      NULL,
      '3',
      '1',
      '1',
      '2',
      '4',
      '2',
      '',
      '1',
      NULL,
      '3',
      '1',
      '2',
      '2',
      '4',
      '',
      '',
      '0',
      '0',
      '0',
      NULL,
      NULL,
      '2',
      '4',
      NULL,
      NULL,
      '2',
      '3',
      '024',
      '43444423',
      NULL,
      NULL,
      '3344043',
      2.333584,
      169.594918,
      1,
      NULL,
      '040144',
      5,
      ' 7-28-1976',
      ' 0- 7-1998',
      33,
      257,
      31,
      NULL,
      6.303817,
      9.913481,
      46.620247,
      11,
      22.216501,
      NULL,
      30,
      7,
      19.202176,
      15.366241,
      NULL,
      NULL,
      13,
      NULL,
      21.801898,
      2.931723,
      22,
      8,
      NULL,
      0.898182,
      0,
      65.611486,
      60.310097,
      18.189316,
      37.915403,
      70,
      48,
      '11- 4-1999',
      32,
      20,
      NULL,
      27,
      98.595565,
      46.287928,
      '10-26-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      41,
      15.118987,
      0,
      2,
      3,
      3,
      ' 6- 4-2002',
      NULL,
      NULL,
      82,
      1.830410,
      1.525724,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      67,
      14,
      16,
      35.559593,
      NULL,
      26,
      45,
      NULL,
      0,
      33.457427,
      31.673674,
      NULL,
      ' 4-23-1984',
      17.095168,
      3,
      NULL,
      25.076767,
      55.230474,
      35.438915,
      10.113269,
      ' 7-26-1990',
      18,
      14.618514,
      ' 4-25-1976',
      8,
      4,
      NULL,
      NULL,
      14,
      NULL,
      0.112016,
      8,
      0,
      41,
      1.285464,
      0.836801,
      5.007553,
      26,
      0,
      NULL,
      NULL,
      1.706859,
      ' 4-15-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      111,
      29,
      '11- 8-1980',
      NULL,
      NULL,
      NULL,
      43.213074,
      ' 9-12-2003',
      38,
      ' 8- 0-1995',
      9.937791,
      12,
      ' 3-23-1992',
      NULL,
      NULL,
      ' 2-27-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      8,
      NULL,
      19,
      35,
      18.163747,
      ' 4- 2-1975',
      0,
      33,
      ' 6- 6-1998',
      1.911461,
      20,
      1,
      4,
      ' 9- 4-1990',
      12.645370,
      1.225323,
      102,
      ' 4- 4-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


