set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9636751';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2023',
      '44044423',
      '41211332',
      '40233304',
      NULL,
      '43402102',
      '14142313',
      '00213110',
      '44014234',
      '04223212',
      '04343220',
      '20022342',
      '02131110',
      NULL,
      '41001044',
      '13024342',
      '41121243',
      '24441221',
      NULL,
      NULL,
      '31303140',
      '12110331',
      '23303220',
      '03021240',
      '14231102',
      '41041101',
      '23443112',
      '43203142',
      '24413231',
      '43304004',
      '21201111',
      '33214013',
      '34221012',
      '42100320',
      NULL,
      NULL,
      '11200004',
      '22302311',
      '42414323',
      '20012331',
      '32020410',
      NULL,
      NULL,
      '23222412',
      '20021442',
      '144',
      NULL,
      9.133988,
      5,
      '0133241',
      2,
      1,
      NULL,
      NULL,
      '321202',
      4,
      ' 0- 0-2002',
      ' 3- 5-1997',
      28,
      53.681445,
      3.164127,
      NULL,
      16,
      7.129950,
      40,
      11,
      7.165474,
      8.870313,
      8,
      0,
      6.066194,
      NULL,
      5.176157,
      6.029425,
      NULL,
      8,
      44.794335,
      8,
      28,
      9,
      2.158849,
      4,
      1,
      NULL,
      21.357268,
      NULL,
      117.710383,
      135.613388,
      89,
      '10- 8-1991',
      11.947415,
      14.404908,
      24.998400,
      4,
      26.791050,
      10,
      ' 9-10-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.585279,
      33.327212,
      17.107660,
      7,
      33.867411,
      NULL,
      ' 6- 4-1987',
      1.235507,
      1,
      9,
      NULL,
      0,
      76,
      0.722450,
      3,
      22.462872,
      NULL,
      NULL,
      NULL,
      ' 6- 2-1985',
      21,
      52.206027,
      4,
      50.842513,
      28,
      26.751296,
      47.203898,
      57.418488,
      63.761966,
      28,
      3,
      29,
      ' 4-24-1980',
      8.421402,
      3,
      15.507152,
      4.520540,
      39.779868,
      3.377229,
      6.494959,
      ' 7-29-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22.763414,
      NULL,
      ' 1- 4-1983',
      NULL,
      NULL,
      NULL,
      1,
      ' 4-29-1987',
      NULL,
      ' 6- 9-1974',
      0.081642,
      5.402454,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      10.551715,
      ' 2-17-1978',
      8,
      9.229222,
      25,
      NULL,
      3.965009,
      NULL,
      '10- 8-1987',
      8.469627,
      51.217478,
      1,
      54.703791,
      ' 4-29-1979',
      NULL,
      1,
      47,
      ' 2- 5-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


