set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9636751';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0132',
      '02021404',
      '20422323',
      '33144420',
      '23200022',
      NULL,
      NULL,
      NULL,
      '41041124',
      '12114014',
      '42420441',
      '31434332',
      '33113400',
      '11300211',
      NULL,
      NULL,
      '44024403',
      '40420324',
      '20011412',
      NULL,
      '24243301',
      NULL,
      '13104033',
      '31143103',
      '00330300',
      NULL,
      '23314341',
      '20424322',
      '41312324',
      '04100432',
      '33111404',
      '12313314',
      '04440133',
      '24130202',
      NULL,
      '33032002',
      NULL,
      '23231102',
      '13121321',
      '21410110',
      '41111014',
      '00133302',
      '10204132',
      '23102340',
      '13242014',
      '413',
      NULL,
      36,
      NULL,
      NULL,
      3,
      10.042107,
      NULL,
      NULL,
      '214023',
      2,
      ' 2- 0-1998',
      NULL,
      52.003404,
      61.705517,
      NULL,
      20,
      19.195819,
      3,
      10.673382,
      NULL,
      6,
      2.815100,
      9.821842,
      3.121982,
      11,
      7,
      1.196853,
      6.925340,
      1.915486,
      NULL,
      17,
      0,
      55,
      19,
      100,
      14,
      1,
      49,
      45,
      69,
      NULL,
      25.461769,
      2,
      ' 7- 2-1993',
      16,
      NULL,
      29.767638,
      20,
      140.263967,
      101.316555,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      76,
      39.369134,
      13.936978,
      6.474403,
      21.022298,
      1,
      '11-11-1976',
      1.251874,
      NULL,
      27.292925,
      1,
      0,
      5.916781,
      0.975676,
      3,
      14.109204,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      24,
      71.501077,
      NULL,
      18.398200,
      29,
      81,
      37,
      NULL,
      NULL,
      NULL,
      11,
      ' 9-27-1995',
      8.581583,
      NULL,
      2.330001,
      28,
      10.764232,
      36,
      NULL,
      ' 5-16-1991',
      39.293045,
      10.034752,
      ' 6-26-1982',
      NULL,
      14,
      NULL,
      NULL,
      8,
      5,
      1,
      2.494828,
      1,
      NULL,
      3.475066,
      0,
      8.942319,
      16.453342,
      2,
      NULL,
      1,
      1,
      ' 1-15-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.940993,
      ' 2-22-1991',
      NULL,
      NULL,
      NULL,
      51.177760,
      NULL,
      NULL,
      ' 4- 8-1977',
      11.014494,
      12,
      ' 4- 6-1996',
      8.098778,
      138.220912,
      ' 8- 8-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      15.482921,
      NULL,
      55,
      19.052102,
      26,
      '10-18-1996',
      NULL,
      177,
      ' 2-21-1987',
      19.108340,
      21.573274,
      NULL,
      25.490066,
      ' 3-16-1995',
      46,
      1.120240,
      203.861065,
      ' 6-14-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


