set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9636751';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '3',
      '2',
      NULL,
      NULL,
      '1',
      '2',
      '1',
      '2',
      NULL,
      '0',
      '3',
      '1',
      NULL,
      '1',
      NULL,
      '1',
      '1',
      '2',
      '0',
      '0',
      NULL,
      '2',
      '2',
      '',
      NULL,
      '',
      '4',
      '4',
      NULL,
      '0',
      '4',
      '',
      NULL,
      '4',
      '2',
      '1',
      '2',
      '2',
      NULL,
      NULL,
      '4',
      '1',
      '1',
      NULL,
      '341',
      '14014104',
      NULL,
      67,
      NULL,
      2.837683,
      90.662593,
      0,
      NULL,
      '022231',
      2.300174,
      ' 3- 9-1997',
      ' 6- 1-1974',
      NULL,
      90,
      NULL,
      NULL,
      17,
      NULL,
      3.889067,
      7.040268,
      2,
      8,
      10.965266,
      2.136791,
      NULL,
      NULL,
      5.814758,
      1.521781,
      NULL,
      0,
      47,
      7.400127,
      16.359936,
      7.435803,
      43.505665,
      2.968608,
      0,
      18.248215,
      101.091434,
      21,
      0.406569,
      7.802401,
      49.869775,
      ' 8-11-1986',
      NULL,
      5.105414,
      21,
      18.794270,
      13,
      NULL,
      ' 1-26-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      27,
      59.427753,
      1,
      38,
      23,
      3.978202,
      NULL,
      NULL,
      1,
      21.615422,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17.903754,
      5.190593,
      1,
      88,
      2.541380,
      NULL,
      27,
      74,
      NULL,
      NULL,
      54.974520,
      7,
      ' 3-16-1983',
      15.768636,
      13,
      10,
      32.155336,
      NULL,
      NULL,
      4.217325,
      ' 7- 0-1991',
      NULL,
      NULL,
      ' 1- 8-1988',
      5,
      7.773674,
      5,
      NULL,
      8,
      NULL,
      1.574579,
      3.901868,
      NULL,
      58.318102,
      1,
      NULL,
      8.803196,
      0.256592,
      NULL,
      0.093646,
      2,
      0.484123,
      ' 2-16-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      19,
      23.931767,
      NULL,
      NULL,
      NULL,
      NULL,
      48,
      ' 4-22-2000',
      21,
      ' 2-19-1998',
      4,
      4,
      '11-27-1986',
      145,
      111.318586,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      3.365787,
      ' 9-19-1997',
      60.854856,
      NULL,
      0,
      ' 7-19-1975',
      1.275252,
      NULL,
      ' 4- 9-1996',
      4.220126,
      2.669306,
      1.072079,
      34.172663,
      ' 7- 3-1989',
      49.033136,
      4,
      70.095787,
      ' 1-23-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


