set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0101253';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      NULL,
      '0',
      '4',
      NULL,
      '3',
      '1',
      NULL,
      '2',
      NULL,
      '1',
      '1',
      '1',
      '4',
      NULL,
      NULL,
      '3',
      '4',
      '0',
      '0',
      '1',
      '0',
      '3',
      '2',
      '',
      '4',
      '',
      '4',
      '1',
      '3',
      '2',
      NULL,
      '',
      NULL,
      '2',
      NULL,
      NULL,
      '4',
      '0',
      '2',
      '2',
      '0',
      '1',
      '4',
      NULL,
      '023',
      '02103432',
      NULL,
      46.217032,
      '2004343',
      1.114009,
      1.341685,
      0,
      1,
      '321433',
      4,
      '11-22-1995',
      NULL,
      70.835199,
      21.645852,
      2,
      NULL,
      NULL,
      4.052896,
      9.051465,
      8.115919,
      2,
      9.760782,
      NULL,
      NULL,
      21.753108,
      4,
      27,
      10,
      11,
      21.301173,
      57,
      9.565577,
      43,
      9.670521,
      8,
      1.359717,
      0.098374,
      59,
      135.550996,
      8.690897,
      121,
      177.735037,
      32.964605,
      NULL,
      39,
      NULL,
      29,
      22,
      13.404183,
      NULL,
      ' 0- 3-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      90.497447,
      15,
      8.818387,
      12.868276,
      NULL,
      1.231143,
      ' 4- 6-1989',
      1.425383,
      1,
      130.302062,
      0,
      5,
      95,
      NULL,
      1.034170,
      58,
      NULL,
      NULL,
      NULL,
      ' 8- 4-1994',
      37.984553,
      NULL,
      NULL,
      91,
      92.134452,
      22,
      11.070302,
      24,
      34,
      NULL,
      67,
      24.367842,
      ' 0-27-1992',
      23,
      13,
      15,
      47,
      3.640955,
      NULL,
      11.119471,
      ' 7-24-2001',
      1,
      11.089261,
      ' 3-21-1978',
      4,
      0.862215,
      1,
      NULL,
      15,
      NULL,
      1.417647,
      NULL,
      2.510917,
      61.721144,
      1.312429,
      7.364063,
      2,
      1,
      7,
      1.794002,
      6.707304,
      0.350674,
      ' 3- 0-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      128.513275,
      2.333073,
      '10-16-1986',
      NULL,
      NULL,
      NULL,
      49,
      NULL,
      6,
      ' 6-29-2002',
      9.736478,
      8,
      ' 4-25-1982',
      11,
      5,
      '10- 3-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      14,
      ' 8- 1-1979',
      56,
      NULL,
      1,
      ' 8- 3-1984',
      0.208160,
      61.187729,
      '10- 0-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


