set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7736674';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4310',
      '43444021',
      '11214140',
      '34211010',
      NULL,
      '43141031',
      '40040020',
      '40440442',
      '33041023',
      '22333302',
      '24044444',
      '11003244',
      NULL,
      '21344134',
      NULL,
      '04424301',
      '33140300',
      '00244133',
      NULL,
      NULL,
      '24100233',
      '03034410',
      '20244043',
      '02013414',
      '01022101',
      '04031104',
      '10204010',
      '12001222',
      '04100323',
      '20134110',
      '33032114',
      '11332123',
      NULL,
      '40034033',
      '43120022',
      '30111142',
      '03210403',
      '14244333',
      '33012134',
      '20330442',
      '23410243',
      '32034122',
      '44301234',
      '11040204',
      '32110021',
      '313',
      NULL,
      NULL,
      NULL,
      '3232232',
      2,
      1.031405,
      3,
      NULL,
      '143214',
      NULL,
      ' 5- 4-1992',
      ' 3-21-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.436005,
      12,
      10,
      14.020169,
      NULL,
      9.507260,
      10,
      13,
      5,
      3,
      10.299616,
      12,
      NULL,
      NULL,
      8.723518,
      26,
      8,
      90.046946,
      3,
      0.218343,
      35.482373,
      NULL,
      28,
      89,
      63.231217,
      108,
      ' 8-15-1998',
      9,
      9.178944,
      9,
      NULL,
      91.420066,
      17.874663,
      NULL,
      NULL,
      3.096990,
      0.592084,
      0,
      9,
      0,
      0,
      1,
      1.918308,
      0,
      0,
      0.696791,
      1.928205,
      1.650467,
      0,
      0.260963,
      1.283402,
      NULL,
      0,
      0.555929,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-16-1993',
      29,
      NULL,
      18.326426,
      0.734271,
      10.194092,
      1,
      ' 5- 0-1980',
      0,
      1,
      56.591183,
      0.797688,
      0.253058,
      NULL,
      1.172714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-25-1987',
      26,
      19,
      30,
      13,
      21,
      13,
      27.045744,
      NULL,
      1.713614,
      51,
      39.181034,
      54,
      ' 3-10-1995',
      17.982798,
      4.079861,
      11,
      30,
      37,
      NULL,
      NULL,
      '10- 6-1999',
      NULL,
      1.677199,
      NULL,
      4.148847,
      8.525359,
      9.047257,
      11,
      1,
      NULL,
      4.279157,
      1,
      0,
      52.532569,
      5,
      8.424192,
      2.399953,
      25.957711,
      0,
      NULL,
      5,
      0,
      ' 7-15-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      133,
      117,
      ' 0-14-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.722707,
      9,
      NULL,
      40,
      44,
      NULL,
      6,
      0,
      ' 6-16-1975',
      NULL,
      NULL,
      NULL,
      2,
      1,
      8,
      ' 7-15-2002',
      43.466679,
      5,
      14.693860,
      ' 2-17-1980',
      0,
      NULL,
      ' 4-10-1982',
      1,
      73.957613,
      7.393696,
      61.663277,
      ' 0-27-1995',
      64.735869,
      1.756570,
      39.351798,
      ' 4-26-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


