set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7736674';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '40001304',
      '22020001',
      NULL,
      '11244313',
      NULL,
      NULL,
      '14123422',
      '24330114',
      NULL,
      '34310324',
      '31221444',
      NULL,
      '21421443',
      '30214311',
      NULL,
      '42120311',
      '43340334',
      '04130404',
      NULL,
      '40143122',
      NULL,
      '12420123',
      '22314220',
      '20042242',
      '22404001',
      '11043201',
      '01441230',
      '20420014',
      '20011203',
      '44322123',
      '03211023',
      NULL,
      '03323312',
      '40043233',
      '21143013',
      '41203022',
      '30044410',
      NULL,
      '42012131',
      '13143200',
      '24433411',
      '21104312',
      NULL,
      NULL,
      '041',
      '43',
      29,
      12.839655,
      '2300114',
      0,
      33.198137,
      2,
      NULL,
      '241111',
      3,
      ' 6-17-1982',
      ' 1-24-1977',
      75,
      NULL,
      6.649955,
      0,
      8.702609,
      5,
      2.265801,
      12.605681,
      1,
      6.577644,
      17,
      11,
      0,
      NULL,
      18.314759,
      0,
      8.451625,
      3,
      3.767673,
      13,
      0,
      0,
      NULL,
      5.150754,
      0.879912,
      71.250559,
      NULL,
      68.547901,
      60.551597,
      53.861850,
      154.801818,
      NULL,
      42,
      5.309769,
      5,
      NULL,
      42,
      NULL,
      ' 2- 2-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      47.431087,
      62.372608,
      17,
      NULL,
      0.494868,
      ' 1-12-1977',
      0,
      0,
      21.677845,
      3,
      1.899361,
      98,
      2.540100,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-27-2000',
      46.191176,
      NULL,
      NULL,
      57,
      9,
      51.737314,
      48.363539,
      5.686944,
      30.489909,
      65.186404,
      73,
      66.402690,
      ' 5-18-2002',
      11,
      15,
      11,
      41,
      28.218306,
      25,
      7.184727,
      ' 0-12-1994',
      11,
      6.440245,
      NULL,
      NULL,
      8,
      13,
      13,
      11.837540,
      4.656930,
      3.872882,
      11.635069,
      1,
      NULL,
      2.881665,
      4.109748,
      8,
      9.375051,
      0,
      3,
      2.749472,
      NULL,
      ' 2-19-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22.369598,
      ' 8-27-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 2-1997',
      1.459621,
      ' 1- 0-1997',
      NULL,
      NULL,
      NULL,
      54.916422,
      37.982582,
      '10-12-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      0.107629,
      ' 6-20-1994',
      19.775032,
      22.438748,
      21.052704,
      ' 9-16-2001',
      2.659197,
      115,
      ' 9- 8-2003',
      5,
      139.786394,
      8.958185,
      123,
      NULL,
      72.979039,
      1,
      66,
      ' 3-10-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


