set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7736674';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      '2',
      NULL,
      '1',
      '0',
      '4',
      '1',
      '0',
      '0',
      NULL,
      NULL,
      '4',
      '3',
      '3',
      NULL,
      '4',
      '4',
      '2',
      '1',
      '',
      '1',
      NULL,
      '1',
      NULL,
      '4',
      '2',
      '2',
      '',
      '',
      '4',
      NULL,
      '4',
      '4',
      '3',
      '4',
      '0',
      '1',
      '1',
      '1',
      NULL,
      '004',
      '23',
      37.250642,
      NULL,
      '4140404',
      2.721396,
      113,
      2,
      NULL,
      '024202',
      NULL,
      ' 0- 5-1998',
      ' 3-29-1980',
      82,
      133.240761,
      3.141045,
      15.306142,
      15,
      3,
      4,
      12,
      21.243595,
      8.072277,
      6,
      2,
      NULL,
      0,
      NULL,
      NULL,
      9,
      15.071987,
      8.438784,
      8,
      7,
      NULL,
      NULL,
      17,
      1.177417,
      84,
      NULL,
      NULL,
      161,
      69.856465,
      142.370948,
      ' 1- 8-1986',
      27,
      NULL,
      26.176135,
      NULL,
      77,
      NULL,
      '11- 2-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19,
      85,
      24.606841,
      18.451607,
      49,
      NULL,
      ' 8- 1-1983',
      0,
      NULL,
      58.927139,
      0,
      0.482688,
      97,
      1,
      0,
      68.455425,
      NULL,
      NULL,
      NULL,
      ' 7-21-1976',
      44,
      36.707771,
      63.987162,
      3.532293,
      27,
      42.963228,
      62,
      53.489461,
      20.717031,
      12.747810,
      28,
      20,
      ' 4-25-2000',
      9,
      19.487891,
      13.952031,
      NULL,
      NULL,
      29.145891,
      7.226264,
      ' 1-21-2002',
      0,
      3,
      NULL,
      NULL,
      NULL,
      7.339267,
      NULL,
      5.197471,
      5.091172,
      1.473136,
      6.325039,
      1.179175,
      2,
      3.950262,
      1.153241,
      0,
      24.999737,
      NULL,
      NULL,
      1.865883,
      NULL,
      ' 9- 8-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      40,
      ' 5-20-1998',
      10.593460,
      ' 7-14-1990',
      11,
      4.936494,
      ' 0- 0-1994',
      108,
      24,
      '10-26-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      ' 3-26-2002',
      11,
      15.632008,
      5,
      ' 5-14-1994',
      0.967670,
      118,
      ' 1- 9-1975',
      2.974642,
      70.337975,
      5.232202,
      NULL,
      ' 7-25-2000',
      63,
      1,
      59,
      ' 0-11-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


