set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7736674';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '2',
      '2',
      '3',
      '2',
      '0',
      NULL,
      '4',
      NULL,
      '4',
      NULL,
      '1',
      '1',
      '0',
      NULL,
      '0',
      '2',
      '0',
      '1',
      NULL,
      '2',
      '3',
      '4',
      '3',
      NULL,
      '1',
      NULL,
      '0',
      '0',
      '4',
      '0',
      NULL,
      NULL,
      '',
      '0',
      '2',
      NULL,
      '1',
      '2',
      NULL,
      '4',
      '2',
      '2',
      '1',
      '3',
      '113',
      '10110311',
      38.761901,
      59.336640,
      NULL,
      3.024980,
      209,
      2,
      NULL,
      NULL,
      1,
      ' 6- 1-1974',
      ' 5-28-1982',
      NULL,
      131,
      12,
      16.662677,
      15.140436,
      NULL,
      20,
      8.867275,
      0,
      10.375773,
      0.251886,
      11.449927,
      31.969118,
      0,
      6.422566,
      NULL,
      NULL,
      6,
      33.088887,
      0.908043,
      19.123817,
      10.160953,
      36,
      11.409231,
      1,
      25.665037,
      26,
      14.306464,
      161.251470,
      NULL,
      89,
      '10-17-1982',
      22.620510,
      24,
      9,
      19,
      116.874344,
      37.442962,
      ' 3-15-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      23.650903,
      22,
      10.615196,
      5,
      40.384597,
      1,
      ' 2-26-1987',
      0,
      1,
      45.471650,
      1.367637,
      1.262732,
      NULL,
      0.458383,
      0,
      14.658369,
      NULL,
      NULL,
      NULL,
      '10-18-1974',
      46.062627,
      19.987939,
      21.685876,
      42.893598,
      23,
      27.754647,
      40.740441,
      50.141038,
      55,
      35,
      12.849339,
      12,
      ' 2-28-1991',
      5.501011,
      10,
      18,
      61,
      16,
      NULL,
      10,
      '11-23-1979',
      6,
      1.848208,
      ' 1-17-1981',
      NULL,
      6.941302,
      7,
      9,
      6,
      5.005046,
      5,
      9,
      NULL,
      3,
      1,
      0.900716,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      ' 0- 9-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-18-2002',
      NULL,
      NULL,
      3.848871,
      NULL,
      NULL,
      41.386885,
      49,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      ' 9- 5-1998',
      32,
      12,
      9,
      '10-27-1985',
      1.166546,
      95.047224,
      ' 8- 3-2003',
      4.025195,
      32.265605,
      NULL,
      74,
      ' 5-23-2002',
      NULL,
      0,
      28.917334,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


