set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7928776';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1211',
      NULL,
      '14314232',
      NULL,
      '00131033',
      '13112331',
      NULL,
      '41024002',
      '01412312',
      NULL,
      NULL,
      '42004412',
      '14111411',
      NULL,
      '44312202',
      '43440104',
      '30041214',
      '04044002',
      NULL,
      '44041124',
      '10032402',
      '21012231',
      '43423334',
      NULL,
      NULL,
      NULL,
      '33222434',
      '32002211',
      '13130224',
      '24302104',
      '13424021',
      NULL,
      '23320344',
      '04420034',
      '22122124',
      NULL,
      '33411304',
      '44341233',
      '12440444',
      '24302214',
      '31311313',
      NULL,
      '11302111',
      '41232100',
      '24000424',
      '334',
      NULL,
      NULL,
      2.343865,
      '2411130',
      0.766754,
      NULL,
      0,
      NULL,
      '112442',
      3,
      ' 1-21-1974',
      NULL,
      22.458915,
      17.262590,
      23,
      2.086495,
      10,
      3.130883,
      17.400204,
      4.328908,
      0.021105,
      17,
      1,
      3,
      4,
      23.211585,
      28,
      2.385994,
      1.743056,
      13.980241,
      53,
      4,
      19.344611,
      31.222054,
      40,
      NULL,
      NULL,
      86.671931,
      83,
      90,
      74.460859,
      165.487395,
      113.898621,
      ' 8-25-1987',
      54.740322,
      NULL,
      18,
      NULL,
      36,
      10.140245,
      ' 6-19-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      86,
      2.438104,
      1,
      33.313374,
      1.648006,
      1,
      NULL,
      1,
      1.901407,
      NULL,
      NULL,
      NULL,
      34.413025,
      1,
      0,
      39.201732,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      61.117804,
      29.710717,
      49.268220,
      75.453716,
      21,
      85.032637,
      101,
      48.174068,
      74,
      100,
      '11-29-1975',
      35.635937,
      24,
      24,
      14.297041,
      0,
      97,
      3,
      ' 6- 7-1977',
      28.001855,
      3,
      ' 5-13-1995',
      6.531762,
      10.475543,
      NULL,
      26.707412,
      NULL,
      NULL,
      1,
      19,
      1.681694,
      NULL,
      0.194240,
      3.065977,
      19,
      12.212670,
      1,
      0.924538,
      0.649055,
      1.198756,
      ' 6- 2-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      255.238623,
      0.006145,
      ' 9-15-1976',
      NULL,
      NULL,
      NULL,
      43.249165,
      NULL,
      38.190502,
      ' 8- 4-1995',
      NULL,
      11.958907,
      ' 0-11-1996',
      NULL,
      18.229664,
      '10-17-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      2.707702,
      '10-14-1993',
      26.823134,
      3.001984,
      55.204866,
      ' 8-12-1993',
      0.594290,
      21,
      '11- 1-1985',
      13,
      NULL,
      13.127044,
      NULL,
      ' 9-18-1975',
      38.541335,
      1.870060,
      NULL,
      '11-27-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


