set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9626489';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0114',
      '30332310',
      '11423044',
      '42421341',
      '02123331',
      '04002331',
      '12033100',
      '33034022',
      '03012313',
      NULL,
      '40121402',
      '30120411',
      '43120144',
      '11432120',
      '31003304',
      '12402101',
      '30044103',
      '12430144',
      '12202013',
      '22114420',
      '30300310',
      '22314244',
      NULL,
      NULL,
      '11202331',
      '13301034',
      '32040123',
      '40413042',
      NULL,
      '21130134',
      '00312313',
      NULL,
      '11301202',
      NULL,
      '03024131',
      '32213442',
      '44302330',
      NULL,
      '31444013',
      '01340310',
      NULL,
      '02114444',
      '30340324',
      NULL,
      NULL,
      '103',
      '44',
      28,
      12.350055,
      '4301020',
      1,
      NULL,
      2,
      NULL,
      '000024',
      NULL,
      '11-20-1980',
      '10-14-1990',
      2.528519,
      77.267165,
      15.582745,
      6.564070,
      16,
      NULL,
      83.584250,
      NULL,
      11.066832,
      NULL,
      13,
      NULL,
      7,
      3.164367,
      31.189586,
      NULL,
      4,
      3,
      28,
      12.882753,
      NULL,
      2.765326,
      37,
      7.089142,
      0,
      71,
      176.172189,
      15.273442,
      5.509137,
      125,
      140,
      '10-17-1987',
      NULL,
      15,
      NULL,
      12.673662,
      27,
      105,
      ' 3-20-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.625618,
      105,
      1.206577,
      5,
      80.525027,
      0,
      1,
      51.965730,
      NULL,
      NULL,
      NULL,
      ' 8- 2-1979',
      NULL,
      66,
      11.854253,
      2,
      43.927095,
      60.517142,
      57,
      NULL,
      42,
      NULL,
      NULL,
      49.826007,
      ' 3- 1-2000',
      28.555916,
      15,
      21,
      10,
      30,
      54.720977,
      14.981330,
      ' 5-20-1989',
      4.174406,
      8.883573,
      ' 4- 0-2000',
      NULL,
      8.903978,
      NULL,
      13,
      NULL,
      4.679118,
      NULL,
      1,
      0,
      NULL,
      3,
      NULL,
      3.381567,
      19,
      6,
      NULL,
      0,
      2,
      ' 5- 5-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.727840,
      NULL,
      NULL,
      NULL,
      6,
      2,
      ' 8- 5-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      12.680641,
      ' 0-29-1997',
      30.732719,
      13.512988,
      0,
      ' 9-25-1978',
      3,
      42.521211,
      '11-29-2000',
      15,
      28,
      NULL,
      NULL,
      ' 4-24-1977',
      49,
      0.551358,
      127,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


