set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9626489';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2031',
      NULL,
      '20231021',
      '14023401',
      '04220341',
      '43034104',
      '31142101',
      '23031043',
      '00024422',
      '13243101',
      '42431123',
      '04313043',
      '22332032',
      '02203021',
      '40333423',
      '14404334',
      '22443303',
      '22020443',
      '22042002',
      '42243111',
      '20140004',
      '44021330',
      '22330404',
      '12143111',
      NULL,
      '11242202',
      '30423134',
      '33312424',
      '22214124',
      '40303010',
      '00202213',
      NULL,
      '42201300',
      '20214243',
      '31004420',
      '20044324',
      '04421403',
      '42204341',
      '33344424',
      '40024013',
      '00110023',
      '30232344',
      '01132014',
      '13404100',
      NULL,
      '444',
      '40',
      47.764824,
      0,
      '1442001',
      1.794555,
      39,
      NULL,
      NULL,
      '411123',
      2.937600,
      ' 3- 3-1999',
      ' 9-26-1984',
      NULL,
      92.799400,
      NULL,
      NULL,
      24.179026,
      4.954954,
      NULL,
      17.069180,
      NULL,
      6,
      18,
      5.650976,
      NULL,
      19,
      14,
      NULL,
      27.375912,
      14.177955,
      NULL,
      11,
      41,
      13,
      NULL,
      8.477642,
      0,
      106,
      140.610905,
      NULL,
      149.282945,
      188.959952,
      150,
      '10- 5-1999',
      NULL,
      47.877958,
      12.082993,
      28,
      NULL,
      137,
      ' 2-20-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      42.041950,
      14,
      4.809369,
      5.986896,
      8,
      5,
      ' 8-11-1979',
      NULL,
      1,
      NULL,
      1.183634,
      NULL,
      NULL,
      0,
      3.872198,
      38.100502,
      NULL,
      NULL,
      NULL,
      ' 6-11-1977',
      21.625331,
      77.311530,
      NULL,
      60.269890,
      71,
      42.188175,
      81,
      17,
      9.378083,
      81.863144,
      61.086150,
      NULL,
      NULL,
      43.661295,
      10,
      13.069814,
      103,
      114,
      61,
      15.286078,
      ' 2-17-1993',
      NULL,
      14,
      NULL,
      12.041085,
      4,
      3.622870,
      1,
      6.982594,
      0.988730,
      1,
      NULL,
      0,
      6,
      1.950495,
      2.638570,
      1.331963,
      NULL,
      9,
      4.825987,
      4.698030,
      2.233803,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15.360352,
      6.747415,
      ' 8-16-1997',
      NULL,
      NULL,
      NULL,
      19,
      ' 4-11-1981',
      46,
      NULL,
      11,
      3,
      ' 0-25-1978',
      NULL,
      NULL,
      ' 6-22-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      14,
      ' 4- 1-2001',
      48,
      2,
      NULL,
      ' 7- 8-1976',
      1,
      174,
      NULL,
      6,
      11.915254,
      2.896634,
      57.898383,
      ' 0-10-1989',
      34,
      0.547898,
      NULL,
      ' 2-28-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


