set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9626489';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '3',
      '1',
      NULL,
      '4',
      '2',
      '1',
      '0',
      '4',
      NULL,
      '0',
      '1',
      '3',
      '3',
      '4',
      NULL,
      NULL,
      '4',
      '3',
      '2',
      '2',
      '0',
      '4',
      '3',
      NULL,
      '4',
      '',
      '1',
      '3',
      '4',
      '3',
      '4',
      '',
      '',
      NULL,
      NULL,
      NULL,
      '3',
      '2',
      '3',
      '0',
      '2',
      '0',
      '2',
      '1',
      NULL,
      '02240143',
      0,
      15.340837,
      '4441301',
      NULL,
      115,
      0,
      NULL,
      '300123',
      4,
      ' 9- 5-1992',
      '11-24-1979',
      7.973683,
      NULL,
      NULL,
      19.414717,
      24,
      3.358956,
      NULL,
      19.856380,
      3.035217,
      3,
      21.216509,
      19,
      NULL,
      5.885536,
      26,
      NULL,
      17,
      7,
      9,
      NULL,
      NULL,
      15.740154,
      11.913194,
      15,
      NULL,
      75,
      163,
      41.783127,
      74.037498,
      NULL,
      115.141632,
      '10- 9-1998',
      47,
      NULL,
      3.462331,
      25,
      NULL,
      NULL,
      ' 4- 9-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      110.167393,
      10.399485,
      1,
      2,
      11.025937,
      10.250431,
      NULL,
      0.165708,
      NULL,
      51.149623,
      1.070630,
      1.278650,
      23,
      1.186320,
      0.302674,
      59,
      NULL,
      NULL,
      NULL,
      ' 9-26-1990',
      49,
      4.448777,
      NULL,
      2,
      43.404688,
      22,
      50.555462,
      67,
      27.634355,
      20.490374,
      19.320477,
      13,
      NULL,
      NULL,
      7,
      NULL,
      64,
      NULL,
      NULL,
      3,
      ' 6- 5-2000',
      3,
      9.946595,
      ' 7-23-1975',
      7.036287,
      13.412746,
      NULL,
      12.619882,
      NULL,
      1,
      0.097991,
      4,
      3.269222,
      43.592355,
      1.414736,
      NULL,
      1,
      4,
      8,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      58.670646,
      11,
      ' 9-27-1988',
      NULL,
      NULL,
      NULL,
      32,
      ' 6- 9-1994',
      21.823424,
      ' 8- 6-1993',
      NULL,
      9.139632,
      ' 2-23-1978',
      66,
      99.774519,
      '10- 3-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      19.336189,
      ' 2-29-2000',
      1.799969,
      6,
      13,
      ' 5- 2-1980',
      3.497098,
      NULL,
      ' 5-26-1976',
      7.944582,
      NULL,
      14.589493,
      79,
      ' 8- 5-1978',
      NULL,
      0,
      49.199722,
      '10- 0-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


