set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9508761';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2412',
      '41442343',
      '42300211',
      '10122120',
      '04024422',
      '20312214',
      '22230323',
      '24241320',
      '43404044',
      NULL,
      '11231342',
      '00124300',
      '41233431',
      '23204344',
      NULL,
      '33100341',
      NULL,
      '02002222',
      '44111104',
      NULL,
      '02024302',
      '42431023',
      '03002140',
      '30301421',
      NULL,
      '40320110',
      '31420213',
      '24442431',
      NULL,
      '43032133',
      '11221011',
      '20024001',
      '03340243',
      NULL,
      '00101122',
      '21230320',
      NULL,
      '10431210',
      NULL,
      NULL,
      '23111220',
      NULL,
      '43322221',
      '14314320',
      NULL,
      '241',
      '31',
      NULL,
      NULL,
      '3220404',
      NULL,
      1.774936,
      0,
      NULL,
      NULL,
      5,
      ' 5-28-1980',
      '11- 2-1975',
      37,
      NULL,
      NULL,
      NULL,
      24,
      10,
      NULL,
      8.468378,
      7.127188,
      1,
      17.550375,
      13.221897,
      13.050722,
      1.967689,
      25.439619,
      16,
      15.266180,
      5,
      NULL,
      0,
      0.352301,
      10,
      38.167328,
      8.033934,
      NULL,
      44,
      NULL,
      9.722839,
      NULL,
      75,
      135,
      ' 2- 5-1978',
      5.803332,
      NULL,
      8,
      6.249388,
      70,
      15.369812,
      ' 5-22-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      70,
      0.421863,
      12,
      4,
      NULL,
      8.927538,
      ' 0-11-1986',
      1.247983,
      1,
      100.112938,
      1.711053,
      NULL,
      NULL,
      0,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 2-1996',
      9.820061,
      41,
      NULL,
      27.442178,
      62.466608,
      NULL,
      76.514691,
      13,
      33,
      35,
      25,
      44.502863,
      NULL,
      NULL,
      11,
      23.183707,
      33.502546,
      27.948271,
      66,
      1.798201,
      ' 0-15-1980',
      1,
      7,
      '11-24-1984',
      13,
      NULL,
      0,
      19.050941,
      5,
      3.123959,
      1,
      14,
      1,
      30.185539,
      1.396401,
      NULL,
      NULL,
      24.100103,
      0.698422,
      0.296048,
      1,
      0,
      ' 6-26-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      90,
      NULL,
      ' 7- 7-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      25.504647,
      ' 8- 4-1985',
      12,
      NULL,
      ' 1-29-1985',
      71,
      NULL,
      ' 8-28-1979',
      NULL,
      0.689682,
      ' 4-11-1991',
      NULL,
      NULL,
      NULL,
      3,
      1,
      8.163371,
      ' 4-19-1975',
      57,
      3.804468,
      34,
      NULL,
      1.396974,
      NULL,
      ' 7-21-1983',
      16.656034,
      49,
      12,
      13,
      ' 0- 3-1998',
      46.210069,
      0.027065,
      43.940960,
      '11-10-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


