set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9508761';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0143',
      '44343023',
      '34100340',
      '24010434',
      NULL,
      NULL,
      '32323421',
      '32424443',
      NULL,
      '32440104',
      '24121331',
      NULL,
      '41214213',
      '23244213',
      '43011131',
      '22441132',
      '12231113',
      '12411013',
      NULL,
      '31424111',
      '20144244',
      '21133202',
      '10414311',
      '21414431',
      '24131312',
      '30043423',
      '11101221',
      NULL,
      '03040342',
      '31131023',
      '03023114',
      '33420004',
      '33410243',
      '41221312',
      NULL,
      '11443322',
      '14230033',
      '24304314',
      '41220033',
      '12223242',
      '00143203',
      '43432211',
      NULL,
      '02002243',
      '00200230',
      NULL,
      '10',
      27,
      8.055746,
      '1133001',
      NULL,
      4.812456,
      1,
      NULL,
      '303120',
      4,
      ' 0- 4-2001',
      ' 3- 5-2001',
      32,
      72.729589,
      NULL,
      11.854667,
      1.297402,
      16,
      NULL,
      7,
      15.885223,
      NULL,
      10,
      9,
      2,
      NULL,
      24.965859,
      0.328548,
      NULL,
      4.339712,
      53.150055,
      14.988712,
      1,
      2.498756,
      NULL,
      6,
      1.582299,
      40.594255,
      146,
      10,
      NULL,
      142,
      85.927801,
      ' 3-29-1990',
      49,
      19,
      NULL,
      21,
      91,
      128,
      ' 3-19-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      49,
      19,
      5,
      11.674905,
      4.375285,
      2.055067,
      ' 6- 6-1990',
      1,
      0.706737,
      51,
      1.447156,
      0,
      8,
      0.468329,
      0,
      78.190298,
      NULL,
      NULL,
      NULL,
      ' 9-20-1981',
      NULL,
      57.807219,
      57,
      41.725120,
      29.532118,
      6,
      NULL,
      53,
      88,
      54.661592,
      NULL,
      NULL,
      '10-16-1986',
      0,
      1,
      7.907538,
      NULL,
      29,
      23.034447,
      NULL,
      ' 3-16-1985',
      0,
      5.027216,
      ' 4-24-1986',
      NULL,
      11,
      NULL,
      13.660028,
      NULL,
      1,
      1,
      9,
      2,
      NULL,
      0.918442,
      0.591033,
      10,
      7.663715,
      2.535668,
      4,
      1.863983,
      2.452495,
      ' 2-16-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      59,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      53,
      ' 6-22-1975',
      8.578682,
      '11-29-2002',
      NULL,
      10.998478,
      ' 2- 6-1998',
      97.274615,
      31.768255,
      ' 7-21-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2.088855,
      ' 4-24-1980',
      NULL,
      26,
      5.316524,
      NULL,
      1.210644,
      4.813194,
      '11- 5-1993',
      13.859725,
      58,
      0,
      4,
      ' 8-11-1977',
      14,
      0.276955,
      41.949548,
      ' 5-22-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


