set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9508761';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '3',
      '1',
      NULL,
      '3',
      '0',
      '3',
      '0',
      '2',
      '0',
      '2',
      '4',
      '2',
      '4',
      '0',
      NULL,
      '3',
      NULL,
      '0',
      '0',
      '0',
      '4',
      '4',
      '1',
      '',
      NULL,
      '',
      '0',
      NULL,
      '4',
      NULL,
      '3',
      NULL,
      '',
      '4',
      NULL,
      '3',
      '4',
      '3',
      '0',
      NULL,
      NULL,
      '4',
      '0',
      NULL,
      '224',
      '02401003',
      0,
      50,
      '0224142',
      2.157412,
      NULL,
      2,
      NULL,
      '220304',
      3,
      '11-13-1991',
      ' 9- 4-1976',
      17,
      1.522458,
      12,
      2,
      3,
      12.447875,
      70.980377,
      5,
      6,
      3.168123,
      23.558150,
      NULL,
      23.857929,
      12.314343,
      18,
      2.639541,
      4,
      1.354141,
      61.146048,
      1.347851,
      62.352164,
      7,
      NULL,
      10,
      NULL,
      53.691752,
      86.944179,
      77.110954,
      165.367431,
      77,
      105.558689,
      '10-12-1977',
      0.896399,
      31.384435,
      NULL,
      NULL,
      139,
      120,
      '10- 9-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.901377,
      11,
      8.621873,
      ' 4-27-1990',
      NULL,
      1.978779,
      130,
      0,
      NULL,
      112.170713,
      1.967866,
      1,
      40,
      NULL,
      NULL,
      NULL,
      NULL,
      16.369527,
      45.962781,
      66.322951,
      52,
      85,
      74,
      78.984924,
      NULL,
      NULL,
      70,
      76,
      NULL,
      '11-28-1985',
      1.107595,
      13,
      5,
      26,
      NULL,
      13.610850,
      NULL,
      '10- 4-1978',
      16,
      NULL,
      ' 1-21-2001',
      8.187144,
      8,
      NULL,
      4,
      NULL,
      5,
      NULL,
      10,
      0,
      40.090619,
      0.409960,
      0.815592,
      3.038525,
      17,
      1.077285,
      1,
      1.281192,
      0,
      ' 3-16-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-20-1984',
      NULL,
      NULL,
      NULL,
      23,
      ' 7-10-1986',
      15,
      '10-13-1983',
      10.685223,
      8,
      ' 2- 2-1997',
      85.551361,
      8.987865,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      12.890556,
      NULL,
      2,
      17.114476,
      34,
      ' 2- 0-1977',
      0.832021,
      199.870436,
      NULL,
      10.093917,
      6,
      9,
      52,
      ' 4-11-1983',
      23,
      1.583950,
      NULL,
      ' 1-10-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


