set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9508761';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '0',
      NULL,
      '4',
      '0',
      '1',
      '1',
      NULL,
      '0',
      '4',
      '3',
      '4',
      '1',
      '2',
      '1',
      '3',
      '0',
      '4',
      '2',
      NULL,
      NULL,
      '1',
      '3',
      '1',
      '',
      NULL,
      '',
      '2',
      '3',
      NULL,
      '0',
      NULL,
      '',
      NULL,
      '0',
      '3',
      NULL,
      '4',
      NULL,
      '2',
      NULL,
      '0',
      '2',
      NULL,
      '4',
      '401',
      '40323130',
      15.372618,
      69.430777,
      NULL,
      1,
      31,
      0,
      0,
      '440401',
      4,
      NULL,
      ' 3-12-1986',
      12.871251,
      200,
      NULL,
      6.798130,
      19.366025,
      0,
      2,
      5.185531,
      1.432763,
      10.439483,
      NULL,
      9,
      6,
      7.864988,
      5,
      4,
      0.756591,
      13.387902,
      13.367303,
      0,
      34,
      4.377696,
      24.355800,
      3,
      NULL,
      56,
      93,
      0.449228,
      129,
      170,
      111,
      ' 0-13-1985',
      4.093825,
      NULL,
      NULL,
      NULL,
      52.868426,
      176.120624,
      ' 0-29-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      55.443935,
      0,
      0,
      1.078314,
      15,
      NULL,
      NULL,
      1.684532,
      0.709692,
      74.994616,
      0.052897,
      1,
      25.347950,
      1.583413,
      1,
      14.941453,
      NULL,
      NULL,
      NULL,
      NULL,
      4.096176,
      31.266246,
      NULL,
      81,
      13.865008,
      NULL,
      NULL,
      NULL,
      NULL,
      48,
      52,
      99.425406,
      ' 9-18-1987',
      1.635472,
      5.705811,
      7,
      2.420712,
      17.819487,
      7.892228,
      NULL,
      ' 4- 2-1999',
      NULL,
      0.940007,
      ' 5-13-1985',
      11.101674,
      12.585194,
      6.630630,
      18.444098,
      NULL,
      5,
      0,
      11.263818,
      1,
      30.417859,
      1,
      1,
      1.283724,
      28,
      0,
      0,
      1,
      1.299160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      121,
      39.157106,
      NULL,
      NULL,
      NULL,
      NULL,
      50,
      ' 7-16-2001',
      14,
      '11-22-1983',
      0,
      5,
      ' 4- 9-1978',
      NULL,
      NULL,
      ' 6-26-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      23.607533,
      '11-13-1999',
      30,
      30,
      29,
      '11- 6-1990',
      4.252734,
      464.215920,
      ' 5- 2-1982',
      16,
      39.329400,
      17,
      29,
      ' 9- 2-1999',
      66,
      0.557883,
      29.510511,
      ' 6-11-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


