set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9672960';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1340',
      '22433040',
      '24204130',
      '33432333',
      '42041131',
      '43443102',
      '02302231',
      '44201031',
      NULL,
      '44304024',
      '44204033',
      '03413040',
      '11320204',
      '20340433',
      '04430302',
      NULL,
      NULL,
      '23124433',
      '12313040',
      '04304004',
      NULL,
      '40401304',
      '22120213',
      NULL,
      '10313021',
      '02244100',
      '32040304',
      '23421242',
      '12012022',
      '10032011',
      '14320403',
      '04002043',
      '02034431',
      '03133323',
      '30103100',
      NULL,
      NULL,
      '42203110',
      '01244431',
      '31430444',
      NULL,
      '34031112',
      '01203304',
      '34421004',
      '42231231',
      NULL,
      '02',
      5,
      18.384967,
      NULL,
      NULL,
      0.232676,
      0,
      NULL,
      '113401',
      2.798455,
      NULL,
      ' 7-21-2001',
      NULL,
      36.608561,
      19.772561,
      2.971280,
      5,
      7.753345,
      25,
      5,
      2,
      2,
      13.479990,
      5,
      3,
      NULL,
      12.817257,
      10.016215,
      9,
      1.860543,
      NULL,
      6,
      12.324187,
      6.475082,
      9.641248,
      11,
      1.915390,
      48,
      96,
      15.613162,
      NULL,
      NULL,
      53,
      ' 9-23-1978',
      8,
      NULL,
      16.945653,
      17.362197,
      29,
      8.856534,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      35.048491,
      4,
      NULL,
      37.525514,
      0.996206,
      5,
      NULL,
      2,
      3.793636,
      158.012218,
      0.419925,
      2.182189,
      58,
      1.839869,
      0.673129,
      50,
      NULL,
      NULL,
      NULL,
      ' 4-15-1995',
      NULL,
      NULL,
      2.939489,
      20.539735,
      23.338205,
      12.107216,
      91.538807,
      14,
      13,
      78.205159,
      NULL,
      37.711149,
      ' 7-19-1986',
      NULL,
      1.351427,
      4.774422,
      NULL,
      39,
      NULL,
      1.735238,
      ' 6-19-2002',
      NULL,
      6,
      ' 2-29-1976',
      5,
      14,
      17.497797,
      5,
      17,
      NULL,
      NULL,
      19.426926,
      1,
      88,
      NULL,
      NULL,
      7,
      12.182069,
      1.833999,
      0.385375,
      0.116112,
      0,
      ' 0- 5-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-26-1998',
      40,
      ' 2-18-1976',
      4,
      2,
      ' 5- 1-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      5,
      ' 2-25-1986',
      36,
      10.454692,
      20,
      ' 2- 2-1987',
      2,
      146.006318,
      ' 3-21-1983',
      3,
      36,
      10.635225,
      52,
      ' 2-16-1975',
      40,
      0.965162,
      71.995040,
      ' 5-17-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


