set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9778756';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '0',
      '0',
      '3',
      '3',
      NULL,
      '4',
      '2',
      '3',
      NULL,
      '4',
      '0',
      '1',
      NULL,
      '3',
      '0',
      '4',
      '0',
      NULL,
      '2',
      NULL,
      '3',
      '2',
      '3',
      '',
      NULL,
      '',
      NULL,
      '0',
      '1',
      '1',
      '3',
      NULL,
      '',
      '3',
      '3',
      '1',
      '2',
      '0',
      NULL,
      '3',
      '1',
      '4',
      '4',
      '2',
      '130',
      '31441032',
      29.295515,
      40.094662,
      '4001344',
      0,
      1.035433,
      2,
      NULL,
      '101441',
      4.697426,
      ' 5- 5-1990',
      ' 2-18-1978',
      10,
      83,
      46.172236,
      6,
      12.928199,
      12.338176,
      55.799275,
      14.280380,
      13,
      12.423394,
      29.602400,
      18,
      9,
      4.989805,
      29.388655,
      2,
      NULL,
      28,
      10.512780,
      NULL,
      7.845934,
      13.800074,
      59.210964,
      24,
      1.414031,
      33,
      191,
      88.774606,
      NULL,
      28.680797,
      123.719338,
      ' 1-11-1985',
      22,
      63,
      28,
      37,
      231.486531,
      140.037677,
      ' 8-12-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      55.647273,
      6.708528,
      7.602234,
      3.328104,
      0.275930,
      2,
      NULL,
      0.247941,
      1.256846,
      NULL,
      0,
      NULL,
      63.895886,
      1,
      0.765721,
      82.301513,
      NULL,
      NULL,
      NULL,
      ' 6-26-1999',
      38,
      NULL,
      48,
      NULL,
      37.247220,
      93.671625,
      54.814489,
      NULL,
      NULL,
      79,
      NULL,
      76,
      ' 7-15-2003',
      0.930718,
      6.163909,
      7,
      0,
      47,
      10.714900,
      1,
      NULL,
      5.646090,
      3,
      '10- 7-1975',
      NULL,
      7,
      14,
      18,
      7,
      1,
      NULL,
      18,
      1.330666,
      77,
      6.386473,
      1,
      13,
      31,
      1.170100,
      1,
      4.377722,
      0,
      '11-19-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      58,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-24-1974',
      34,
      ' 2-26-1978',
      1.002313,
      10.202174,
      NULL,
      NULL,
      92.929809,
      ' 8-17-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      ' 9-12-1987',
      34,
      17,
      22.616582,
      '11- 6-1979',
      0,
      5.150118,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


