set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8835304';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0400',
      '33104413',
      '33404441',
      '34314222',
      '44001242',
      '21203041',
      '13004222',
      '43304441',
      '04321312',
      '02304334',
      '42042121',
      '03023311',
      '33441133',
      '00320232',
      '40241044',
      NULL,
      '14243132',
      '44401404',
      NULL,
      '42222424',
      '21040204',
      NULL,
      NULL,
      NULL,
      '13004020',
      '00100000',
      '03314142',
      '04320400',
      NULL,
      '44003413',
      '44404021',
      '33123324',
      '32031141',
      '42420013',
      '32004432',
      '40131022',
      '30224142',
      '23030322',
      '21130302',
      '43443041',
      '40123401',
      '10400210',
      '34340141',
      '33443422',
      '34144001',
      '211',
      '21',
      NULL,
      NULL,
      '2313442',
      2.599276,
      1.143379,
      0,
      NULL,
      NULL,
      2.413836,
      ' 9-24-1990',
      ' 1- 8-1996',
      37,
      NULL,
      NULL,
      15,
      24.222863,
      NULL,
      28,
      15,
      5,
      6.924814,
      18,
      10.664356,
      37.855551,
      8.406520,
      13.000434,
      15,
      NULL,
      16,
      7.805450,
      7.899699,
      48,
      1,
      132.264322,
      NULL,
      NULL,
      47,
      77,
      39.653989,
      106.658659,
      57.917584,
      103.165160,
      ' 5- 1-1989',
      NULL,
      12.163309,
      10.258418,
      28.880311,
      20,
      66.267269,
      ' 8- 1-1990',
      0.476294,
      1,
      1.905597,
      NULL,
      1.882419,
      0,
      3,
      7.262082,
      1,
      1,
      2,
      1.461175,
      1.528112,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      43.363913,
      4.194037,
      4.822050,
      5.411800,
      8.901552,
      2.291486,
      '10-15-1977',
      0,
      1,
      34,
      NULL,
      0.762973,
      198,
      2.049546,
      1,
      1,
      1,
      3,
      89.673793,
      ' 8-15-1977',
      NULL,
      108.180687,
      51.132998,
      64,
      87,
      96.637373,
      39,
      1,
      28.921607,
      66,
      49,
      49,
      ' 8- 5-1986',
      NULL,
      NULL,
      31.844679,
      4,
      84,
      NULL,
      NULL,
      ' 0-18-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.914577,
      3,
      NULL,
      90.053862,
      NULL,
      NULL,
      24,
      7,
      NULL,
      20,
      NULL,
      17.592171,
      ' 7-29-1995',
      8,
      19,
      NULL,
      87,
      NULL,
      '10- 1-1974',
      3.740667,
      7,
      NULL,
      9.072299,
      6,
      ' 2- 4-1995',
      2,
      NULL,
      3,
      ' 1-28-2001',
      2.746331,
      7,
      26.033866,
      ' 8-16-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6);
commit;
end;
/


