set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7915686';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      NULL,
      '2',
      '0',
      '2',
      '0',
      NULL,
      '1',
      '0',
      NULL,
      NULL,
      '3',
      '3',
      '1',
      NULL,
      '0',
      NULL,
      '0',
      NULL,
      '4',
      '0',
      '2',
      '3',
      NULL,
      NULL,
      '0',
      '',
      '4',
      '2',
      '0',
      NULL,
      '3',
      '',
      '',
      '1',
      '1',
      '4',
      '1',
      NULL,
      NULL,
      '3',
      NULL,
      '2',
      '1',
      NULL,
      NULL,
      '21233314',
      40.627606,
      54.607813,
      '2220142',
      0,
      1.781362,
      2,
      NULL,
      '124403',
      2.649280,
      ' 0-21-2003',
      ' 2-14-1977',
      NULL,
      64,
      32,
      23,
      2,
      3,
      56,
      13.370923,
      14,
      NULL,
      4.946427,
      8.430480,
      13.182918,
      NULL,
      35,
      16.591655,
      6,
      0,
      24,
      NULL,
      NULL,
      5.170071,
      84.141227,
      1,
      0.449594,
      90,
      174,
      27,
      154.039342,
      25.976026,
      35.350704,
      NULL,
      16,
      34.515405,
      NULL,
      5,
      99,
      168.495433,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19.293861,
      27.640884,
      NULL,
      7,
      NULL,
      2.461370,
      ' 1-13-1978',
      1,
      0.481125,
      125,
      NULL,
      5,
      129.139336,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      77,
      44,
      26.348712,
      38,
      88,
      59,
      NULL,
      35.327533,
      58,
      13.461247,
      75,
      NULL,
      ' 9-26-1978',
      1,
      18,
      7,
      NULL,
      22.750840,
      21.560064,
      4,
      ' 5-25-1998',
      1,
      16.644205,
      ' 0-14-1995',
      5,
      NULL,
      15.783187,
      9.971729,
      6.102862,
      1.508003,
      1,
      23,
      1.369004,
      74.672701,
      0.651070,
      1.085406,
      4.681883,
      20.656929,
      2.854415,
      0.827922,
      1.014028,
      1.817555,
      ' 3-16-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      93,
      30,
      ' 1-17-1978',
      NULL,
      NULL,
      NULL,
      52.772048,
      ' 7-18-1981',
      43,
      NULL,
      2,
      NULL,
      ' 7-26-2000',
      91,
      41,
      ' 1-26-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      21.228170,
      ' 4-12-1992',
      19,
      NULL,
      16,
      ' 3-27-1994',
      0,
      41.027318,
      NULL,
      5.438577,
      NULL,
      8,
      24.304048,
      ' 6-11-1981',
      66.414841,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


