set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7915686';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '2',
      '4',
      '0',
      '4',
      NULL,
      NULL,
      '3',
      '2',
      '0',
      '3',
      NULL,
      '4',
      '4',
      NULL,
      '0',
      '1',
      '4',
      '1',
      '3',
      '4',
      NULL,
      NULL,
      NULL,
      '',
      '3',
      '',
      '0',
      '3',
      '3',
      '2',
      '3',
      NULL,
      NULL,
      '2',
      '4',
      '3',
      '4',
      NULL,
      NULL,
      '1',
      NULL,
      '1',
      NULL,
      '2',
      '302',
      '10102313',
      51.710628,
      62.205480,
      '0112301',
      1.901799,
      38.560386,
      2,
      NULL,
      NULL,
      1.120063,
      ' 4- 2-1994',
      ' 5-13-1998',
      91.956842,
      122.464368,
      40.243778,
      22.339621,
      15,
      10.448121,
      13.587768,
      11.361975,
      21.924916,
      11,
      NULL,
      21.391375,
      46,
      23.671729,
      NULL,
      15,
      NULL,
      NULL,
      NULL,
      7,
      49.842762,
      NULL,
      9,
      3.046755,
      0.953336,
      6,
      213.222091,
      112.829755,
      NULL,
      178.098386,
      116,
      ' 4-16-1985',
      17,
      46.883111,
      10.278873,
      NULL,
      NULL,
      NULL,
      '10- 0-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17,
      NULL,
      2.316913,
      4,
      1.546553,
      4.376555,
      ' 3-16-1974',
      0.245326,
      1.378092,
      181,
      0.400590,
      1,
      16.121887,
      NULL,
      0.909867,
      39,
      NULL,
      NULL,
      NULL,
      ' 0- 8-1993',
      67,
      80,
      84.148812,
      50.624314,
      NULL,
      75,
      88.382823,
      NULL,
      62,
      22,
      NULL,
      34,
      NULL,
      NULL,
      21.567465,
      16,
      12.467442,
      29,
      NULL,
      2.310784,
      ' 3-25-1980',
      5,
      13.184622,
      ' 4-25-1978',
      NULL,
      NULL,
      6.969116,
      13,
      NULL,
      5,
      0,
      15.915094,
      0,
      73,
      0.758655,
      1.723843,
      19.151844,
      17.770148,
      NULL,
      1.422645,
      NULL,
      NULL,
      '11- 3-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      118.680210,
      NULL,
      ' 2-23-1999',
      NULL,
      NULL,
      NULL,
      19,
      NULL,
      NULL,
      NULL,
      10.400836,
      7,
      ' 2- 6-2003',
      155,
      NULL,
      ' 3-11-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      14.101270,
      NULL,
      59.978817,
      NULL,
      NULL,
      ' 7-12-1976',
      1,
      NULL,
      NULL,
      0,
      15,
      7.983434,
      NULL,
      ' 3- 5-1979',
      41,
      1.392008,
      106,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


